% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir_static_model.R
\name{sir_static_model}
\alias{sir_static_model}
\title{SIR static model (age-heterogeneous, endemic equilibrium)}
\usage{
sir_static_model(a, state, parameters)
}
\arguments{
\item{a}{age sequence.}

\item{state}{the initial state of the system.}

\item{parameters}{the model's parameter.}
}
\value{
list of class sir_static_model with the following items
  \item{parameters}{list of parameters used for fitting the model}
  \item{output}{matrix of proportion for each compartment over time}
}
\description{
Refers to section 3.2.2.
}
\details{
In \code{state}:

  - \code{s}: proportion susceptible

  - \code{i}: proportion infected

  - \code{r}: proportion recovered

In \code{parameters}:

  - \code{lambda}: natural death rate

  - \code{nu}: recovery rate
}
\examples{
state <- c(s=0.99,i=0.01,r=0)
parameters <- c(
  lambda = 0.05,
  nu=1/(14/365) # 2 weeks to recover
)
ages<-seq(0, 90, by=0.01)
model = sir_static_model(ages, state, parameters)
model

}
