% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-upload.R
\name{Part}
\alias{Part}
\title{R6 Class representing a part of the uploading file}
\description{
R6 Class representing a resource for managing parts of the files' uploads.
}
\examples{

## ------------------------------------------------
## Method `Part$print`
## ------------------------------------------------

\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Print upload part information
 upload_part_object$print()
}

## ------------------------------------------------
## Method `Part$upload_info_part`
## ------------------------------------------------

\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Get upload part status information
 upload_part_object$upload_info_part(upload_id = upload_id)
}

## ------------------------------------------------
## Method `Part$upload_complete_part`
## ------------------------------------------------

\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Report an uploaded part
 upload_part_object$upload_complete_part(upload_id = upload_id)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{part_number}}{Part number.}

\item{\code{part_size}}{Part size.}

\item{\code{url}}{The URL to which to make the HTTP part upload request.}

\item{\code{expires}}{ISO 8601 combined date and time representation
in Coordinated Universal Time (UTC) by when the HTTP
part upload request should be made.}

\item{\code{headers}}{A map of headers and values that should be
set when making the HTTP part upload request.}

\item{\code{success_codes}}{A list of status codes returned by
the HTTP part upload request that should be recognized as success.
A successful part upload request should be reported back
to the API in a call to report an uploaded file part by
passing the information collected from the report object.}

\item{\code{report}}{Report object.}

\item{\code{etag}}{ETag received after starting a part upload.}

\item{\code{auth}}{Authentication object.}

\item{\code{response}}{Response object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Part-new}{\code{Part$new()}}
\item \href{#method-Part-print}{\code{Part$print()}}
\item \href{#method-Part-upload_info_part}{\code{Part$upload_info_part()}}
\item \href{#method-Part-upload_complete_part}{\code{Part$upload_complete_part()}}
\item \href{#method-Part-clone}{\code{Part$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Part-new"></a>}}
\if{latex}{\out{\hypertarget{method-Part-new}{}}}
\subsection{Method \code{new()}}{
Create a new Part object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Part$new(
  part_number = NA,
  part_size = NA,
  url = NA,
  expires = NA,
  headers = NA,
  success_codes = NA,
  report = NA,
  etag = NA,
  auth = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{part_number}}{Part number.}

\item{\code{part_size}}{Part size.}

\item{\code{url}}{The URL to which to make the HTTP part upload request.}

\item{\code{expires}}{Combined date and time representation
in UTC by when the HTTP part upload request should be made.}

\item{\code{headers}}{A map of headers and values that should be
set when making the HTTP part upload request.}

\item{\code{success_codes}}{A list of status codes returned by
the HTTP part upload request that should be recognized as success.}

\item{\code{report}}{Report object.}

\item{\code{etag}}{ETag received after starting a part upload.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Part-print"></a>}}
\if{latex}{\out{\hypertarget{method-Part-print}{}}}
\subsection{Method \code{print()}}{
Print method for Part class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Part$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Print upload part information
 upload_part_object$print()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Part-upload_info_part"></a>}}
\if{latex}{\out{\hypertarget{method-Part-upload_info_part}{}}}
\subsection{Method \code{upload_info_part()}}{
Get upload part info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Part$upload_info_part(upload_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{upload_id}}{Upload object or ID of the upload process to which the
part belongs.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Get upload part status information
 upload_part_object$upload_info_part(upload_id = upload_id)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Part-upload_complete_part"></a>}}
\if{latex}{\out{\hypertarget{method-Part-upload_complete_part}{}}}
\subsection{Method \code{upload_complete_part()}}{
Report an uploaded part.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Part$upload_complete_part(upload_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{upload_id}}{Upload object or ID of the upload process that part
belongs to.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 upload_part_object <- Part$new(
                        part_number = part_number,
                        part_size = part_size,
                        auth = auth
                      )

 # Report an uploaded part
 upload_part_object$upload_complete_part(upload_id = upload_id)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Part-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Part-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Part$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
