% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-solvers.R
\name{sfcr_random}
\alias{sfcr_random}
\title{Generate random sequences inside \code{sfcr_set()}}
\usage{
sfcr_random(.f, ...)
}
\arguments{
\item{.f}{This argument accepts three options: "rnorm", "rbinom", and "runif",
and implement the respective functions from the built-in \code{stats} package.}

\item{...}{Extra arguments to be passed to the \code{stats} generator functions}
}
\description{
This function can only be used inside \code{sfcr_set()} when generating variables.
It smartly guesses the length of the \code{sfcr_baseline()} model or of the
\code{sfcr_shock()} that it is inserted.
}
\examples{
# Create a random normal series to pass along an endogenous series
# Example taken from model PC EXT 2.
sfcr_set(
    Ra ~ sfcr_random("rnorm", mean=0, sd=0.05)
)

}
\author{
João Macalós
}
