% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_curve.R
\name{hilbert_curve}
\alias{hilbert_curve}
\alias{moore_curve}
\alias{beta_omega_curve}
\alias{peano_curve}
\alias{meander_curve}
\alias{h_curve}
\title{Various curves in their standard forms}
\usage{
hilbert_curve(level = 2L, by = "Cpp")

moore_curve(level = 2L)

beta_omega_curve(level = 2L)

peano_curve(level = 2L, pattern = "vvvvvvvvv", by = "Cpp")

meander_curve(level = 2L, pattern = "fffffffff", code = rep(1, level))

h_curve(iteration = 2L)
}
\arguments{
\item{level}{Level of the curve.}

\item{by}{Which implementation? Only for the testing purpose.}

\item{pattern}{The orientation of units on level-2, i.e. the orientation of the 9 3x3 units. The
value should be a string with 9 letters of "v"/"h" (vertical or horizontal) for the Peano curve,
and "f"/"b" (forward or backward) for the Meander curve. The length of the string should be maximal 9.
If the length is smaller than 9, the stringis automatically recycled.}

\item{code}{Internally used.}

\item{iteration}{Number of iterations.}
}
\value{
A two-column matrix of coordinates of points on the curve.
}
\description{
Various curves in their standard forms
}
\details{
These are just special forms of \code{\link[=sfc_2x2]{sfc_2x2()}}, \code{\link[=sfc_3x3_peano]{sfc_3x3_peano()}}, \code{\link[=sfc_3x3_meander]{sfc_3x3_meander()}} and \code{\link[=sfc_h]{sfc_h()}}.
}
\examples{
hilbert_curve(2)
draw_multiple_curves(
    hilbert_curve(3),
    hilbert_curve(4),
    nrow = 1
)
draw_multiple_curves(
    moore_curve(3),
    moore_curve(4),
    nrow = 1
)
draw_multiple_curves(
    beta_omega_curve(3),
    beta_omega_curve(4),
    nrow = 1
)
draw_multiple_curves(
    peano_curve(2),
    peano_curve(3),
    nrow = 1
)
draw_multiple_curves(
    peano_curve(3, pattern = "vh"),
    peano_curve(3, pattern = "vvvhhhvvv"),
    nrow = 1
)
draw_multiple_curves(
    meander_curve(2),
    meander_curve(3),
    nrow = 1
)
draw_multiple_curves(
    meander_curve(3, pattern = "fbfbfbfbf"),
    meander_curve(3, pattern = "bbbbbffff"),
    nrow = 1
)
draw_multiple_curves(
    h_curve(1),
    h_curve(2),
    nrow = 1, closed = TRUE
)
}
