% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp-std_dev_ellipse.R
\name{std_dev_ellipse}
\alias{std_dev_ellipse}
\title{Calculation Standard Deviational Ellipse}
\usage{
std_dev_ellipse(geometry)
}
\arguments{
\item{geometry}{an sfc object. If a polygon, uses \code{\link[sf:geos_unary]{sf::st_point_on_surface()}}.}
}
\value{
An sf object with three columns
\itemize{
\item \code{sx}: major axis radius in CRS units,
\item \code{sy}: minor axis radius in CRS units,
\item \code{theta}: degree rotation of the ellipse.
}

sf object's geometry is the center mean point.
}
\description{
From an sf object containing points, calculate the standard deviational ellipse.
}
\details{
The bulk of this function is derived from the archived CRAN package aspace version 3.2.0.
}
\examples{
#' # Make a grid to sample from
grd <- sf::st_make_grid(n = c(1, 1), cellsize = c(100, 100), offset = c(0,0))

# sample 100 points
pnts <- sf::st_sample(grd, 100)
std_dev_ellipse(pnts)
}
