% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2o.get_ids.R
\name{h2o.get_ids}
\alias{h2o.get_ids}
\title{Extract model IDs from H2O AutoML or Grid objects}
\usage{
h2o.get_ids(h2oboard)
}
\arguments{
\item{h2oboard}{An object inheriting from \code{"H2OAutoML"} or \code{"H2OGrid"}.}
}
\value{
A character vector of trained model IDs.
}
\description{
Extracts model IDs from a \code{"H2OAutoML"} object (via the leaderboard)
             or from a \code{"H2OGrid"} object.
}
\examples{

\dontrun{
library(h2o)
h2o.init(ignore_config = TRUE, nthreads = 2, bind_to_localhost = FALSE, insecure = TRUE)
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, max_runtime_secs = 30)

# get the model IDs
ids <- h2o.get_ids(aml)
}
}
\author{
E. F. Haghish
}
