% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack_randomized.R
\name{pack_randomized}
\alias{pack_randomized}
\title{pack_randomized}
\usage{
pack_randomized(raster)
}
\arguments{
\item{raster}{rd_ras object with randomized raster.}
}
\value{
rd_ras
}
\description{
Save randomized raster object
}
\details{
Because of how SpatRaster are saved (need to be packed), this function wraps
all raster objects and prepares them for saving first. For further details, see \code{wrap}.
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(terra::rast(landscape), n = 5, style = "fisher")
landscape_random <- randomize_raster(landscape_classified, n_random = 3)
x <- pack_randomized(raster = landscape_random)
}

}
\seealso{
\code{\link{unpack_randomized}},
\code{\link[terra]{wrap}}
}
