% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraSlider.R
\name{chakraSliderInput}
\alias{chakraSliderInput}
\title{Chakra slider}
\usage{
chakraSliderInput(
  inputId,
  label = NULL,
  value,
  min,
  max,
  step = NULL,
  width = "100\%",
  size = "md",
  numberInputOptions = list(),
  trackColor = NULL,
  thumbOptions = list(),
  gap = "2rem"
)
}
\arguments{
\item{inputId}{the input slot that will be used to access the value}

\item{label}{the label for the widget; this can be some HTML code}

\item{value}{initial value}

\item{min}{minimum allowed value}

\item{max}{maximum allowed value}

\item{step}{stepping interval to use when adjusting the value}

\item{width}{width of the widget, e.g. \code{"50\%"} or \code{"200px"}}

\item{size}{size of the widget, can be \code{"sm"} (small),
\code{"md"} (medium) or \code{"lg"} (large)}

\item{numberInputOptions}{list of options for the number input;
see \code{\link{numberInputOptions}}}

\item{trackColor}{color(s) for the track of the slider, can be
a single color or a vector of two colors, one for the left side
and one for the right side}

\item{thumbOptions}{list of options for the thumb of the slider;
see \code{\link{thumbOptions}}}

\item{gap}{size of the gap between the number input and the slider,
e.g. \code{"3px"} or \code{"5\%"}}
}
\description{
This creates a chakra slider in the Shiny UI. A chakra slider
has two elements: a number input and a slider, which are linked together.
}
\examples{
library(shiny)
library(shinyChakraSlider)

ui <- fluidPage(
  br(),
  chakraSliderInput(
    "slider",
    label = tags$span(
      style = "font-size: 20px; font-style: italic; color: darkred;",
      "Chakra Slider"
    ),
    value = 5, min = 0, max = 10, step = 0.5,
    width = "50\%", size = "lg",
    numberInputOptions = numberInputOptions(
      width = "25\%",
      fontSize = "15px",
      fontColor = "navyblue",
      borderColor = "gold",
      borderWidth = "medium",
      focusBorderColor = "navyblue",
      stepperColor = c("palegreen", "lightpink")
    ),
    trackColor = c("lightpink2", "springgreen"),
    thumbOptions = thumbOptions(
      width = "30px",
      height = "30px",
      color = "white",
      borderColor = "darkblue",
      borderWidth = "8px",
      icon = "circle",
      iconSize = "2.5em"
    )
  ),
  br(),
  tags$div(
    style = "width: 50\%;",
    wellPanel(
      style =
        "vertical-align: top; width: 150px; padding: 11.5px; float: left;",
      textOutput("value"),
    ),
    tags$div(
      style = "float: right;",
      actionButton("update", "Update value", class = "btn-danger btn-lg")
    )
  )
)

server <- function(input, output, session){

  output[["value"]] <- renderText({
    paste0("Value: ", input[["slider"]])
  })

  observeEvent(input[["update"]], {
    updateChakraSliderInput(session, "slider", value = 8)
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
