% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{switch}
\alias{switch}
\alias{switch_input}
\alias{update_switch_input}
\title{switch}
\usage{
switch_input(inputId, ..., value = default_value)

update_switch_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI switch component.
}
\description{
The Switch component is used as an alternative between checked and not checked states.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{value}. Type: \code{string}. Default: \code{NA}.
\item \bold{name}. Type: \code{string}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"primary"}.
\item \bold{thumbIcon}. Type: \code{ThumbIconProps}. Default: \code{NA}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{isSelected}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{defaultSelected}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isReadOnly}. Type: \code{boolean}. Default: \code{NA}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base"OR "wrapper"OR "thumb"OR "label" OR "startContent" OR "endContent" OR "thumbIcon" , string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onChange}. Type: \code{React.ChangeEvent<HTMLInputElement>}. Default: \code{NA}.
\item \bold{onValueChange}. Type: \code{(isSelected: boolean) => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)
library(shiny.react)

base_style <- paste(
  "inline-flex flex-row-reverse w-full max-w-md bg-content1 hover:bg-content2",
  "items-center justify-between cursor-pointer rounded-lg gap-2 p-4 border-2",
  "border-transparent data-[selected=true]:border-primary"
)

thumb_style <- paste(
  "w-6 h-6 border-2 shadow-lg group-data-[hover=true]:border-primary",
  "group-data-[selected=true]:ml-6 group-data-[pressed=true]:w-7",
  "group-data-[selected]:group-data-[pressed]:ml-4"
)

ui <- nextui_page(
  div(
    class = "flex flex-col",
    action_button("update", "Toggle switch"),
    spacer(y = 2),
    p("Basic"),
    switch_input(
      inputId = "switch",
      value = TRUE,
      size = "xs"
    ),
    textOutput("switch_val"),
    spacer(y = 5),
    p("Custom style"),
    spacer(y = 2),
    switch_input(
      "custom_switch",
      classNames = JS(
        sprintf(
          "{
          base: '\%s',
          wrapper: 'p-0 h-4 overflow-visible',
          thumb: '\%s'
        }",
          base_style,
          thumb_style
        )
      ),
      div(
        className = "flex flex-col gap-1",
        p(className = "text-medium", "Enable early acces"),
        p(
          className = "text-tiny text-default-400",
          "Get access to new features before they are released."
        )
      )
    )
  )
)

server <- function(input, output, session) {
  output$switch_val <- renderText(input$switch)
  observeEvent(input$update, {
    update_switch_input(session, "switch", value = !input$switch)
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/switch}.
}
