% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/note_crud.R
\name{shinynotes}
\alias{shinynotes}
\title{Shiny notes module - server function}
\usage{
shinynotes(
  input,
  output,
  session,
  group_column,
  selected_group,
  group_options,
  table_id,
  db_conn,
  category_options = NA,
  style_options = default_styles()
)
}
\arguments{
\item{input}{Standard \code{shiny} input}

\item{output}{Standard \code{shiny} output}

\item{session}{Standard \code{shiny} session}

\item{group_column}{Column in table to group and filter notes by.}

\item{selected_group}{Currently selected group column value.}

\item{group_options}{Group column row value options.}

\item{table_id}{Named list with member 'table' and 'schema' referring to a
database table containing notes.}

\item{db_conn}{An object that inherits from
\code{\link[DBI:DBIConnection-class]{DBIConnection-class}}, typically generated by
\code{\link[DBI:dbConnect]{dbConnect()}}}

\item{category_options}{Category column row value options. Useful if table is
empty. Default is \code{NA} (retrieved from data)}

\item{style_options}{Optional named list of \code{CSS} styles to apply to
note panel elements.}
}
\value{
Module server component. Reactive expression containing the currently
  selected note data and database connection.
}
\description{
Server function for the \code{shinynotes} module.
}
\details{
The \code{style_options} argument contains the following default
  values:
  \itemize{
   \item type = "paragraph"
   \item header
   \itemize{
    \item color = "#4b2c71" 
    \item style = "font-weight: bold; text-decoration: underline;"
   }
   \item panel
   \itemize{ 
    \item status = "default"
    \item background = "#fdfeff" 
    \item scrollY = "scroll"
    \item max_height = "600px" 
    \item height = "100%" 
    \item padding = "4px"
    \item width = "100%"
    \item border_width = "2px" 
    \item border_radius = "4px"
    \item border_style = "solid"
    \item border_color = "#f5f5f5"
    \item style = "text-align:left; margin-right:1px;"
   }
   \item paragraph_style = "margin: 0px 0px 1px;white-space: pre-wrap;"
   \item bullet_style = "white-space: pre-wrap;"
   \item hr_style = "margin-top:10px; margin-bottom:10px;"
   \item ignoreCase = TRUE 
  }
}
\examples{
if(interactive()){
  shiny::callModule(
    module = shinynotes,
    id = "paragraph",
    style_options = shiny::reactive({
    list(
      "type" = "bullets",
      "header" = list("color" = "#ccc"),
      "panel" = list("scrollY" = TRUE)
      )
    }),
    group_column = "package",
    selected_group = shiny::reactive("shiny"),
    group_options = c("shiny", "shinyWidgets", "dplyr"),
    table_id = list(table = "scroll_demo", schema = "notes"),
    db_conn = connect_sqlite(auto_disconnect = FALSE)
  )
}

}
