% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterInput.R
\name{filterInput}
\alias{filterInput}
\title{Create a \pkg{shiny} Input}
\usage{
filterInput(x, ...)
}
\arguments{
\item{x}{The object used to create the input.}

\item{...}{Arguments used for input selection or passed to the selected
input. See details.}
}
\value{
One of the following \pkg{shiny} inputs is returned, based on the
type of object passed to \code{x}, and other specified arguments. See
\code{vignette("filter-input-catalog")} for the full list of examples.

\tabular{lll}{
\strong{Value}          \tab \strong{\code{x}}                     \tab \strong{Arguments}              \cr

\link[shiny:dateInput]{shiny::dateInput}      \tab Date, POSIXt                     \tab \emph{default}                       \cr
\link[shiny:dateRangeInput]{shiny::dateRangeInput} \tab Date, POSIXt                     \tab \code{range = TRUE}                  \cr
\link[shiny:numericInput]{shiny::numericInput}   \tab numeric                          \tab \emph{default}                       \cr
\link[shiny:radioButtons]{shiny::radioButtons}   \tab character, factor, list, logical \tab \code{radio = TRUE}                  \cr
\link[shiny:selectInput]{shiny::selectInput}    \tab character, factor, list, logical \tab \emph{default}                       \cr
\link[shiny:selectInput]{shiny::selectizeInput} \tab character, factor, list, logical \tab \code{selectize = TRUE}              \cr
\link[shiny:sliderInput]{shiny::sliderInput}    \tab numeric                          \tab \code{slider = TRUE}                 \cr
\link[shiny:textAreaInput]{shiny::textAreaInput}  \tab character                        \tab \code{textbox = TRUE}, \code{area = TRUE} \cr
\link[shiny:textInput]{shiny::textInput}      \tab character                        \tab \code{textbox = TRUE}                \cr
}
}
\description{
Selects and creates a \pkg{shiny} input based the type of object \code{x} and
other arguments.
}
\details{
The following arguments passed to \code{...} are supported:
\tabular{ll}{
\code{area} \tab
\emph{(character)}. Logical. Controls whether to use  \link[shiny:textAreaInput]{shiny::textAreaInput}
(\code{TRUE}) or \link[shiny:textInput]{shiny::textInput} (\code{FALSE}, default). Only applies when
\code{textbox} is \code{TRUE}. \cr

\code{range} \tab
\emph{(Date, POSIXt)}. Logical. Controls whether to use \link[shiny:dateRangeInput]{shiny::dateRangeInput}
(\code{TRUE}) or \link[shiny:dateInput]{shiny::dateInput} (\code{FALSE}, default). \cr

\code{selectize} \tab
\emph{(character, factor, list, logical)}. Logical. Controls whether to use
\link[shiny:selectInput]{shiny::selectizeInput} (\code{TRUE}) or \link[shiny:selectInput]{shiny::selectInput}
(\code{FALSE}, default). For character vectors, \code{selectize} only applies if
\code{textbox} is \code{FALSE}, the default. \cr

\code{slider} \tab
\emph{(numeric)}. Logical. Controls whether to use \link[shiny:sliderInput]{shiny::sliderInput}
(\code{TRUE}) or \link[shiny:numericInput]{shiny::numericInput} (\code{FALSE}, default)  . \cr

\code{textbox} \tab
\emph{(character)}. Logical. Controls whether to use a text input
(\code{TRUE}) or a dropdown input (\code{FALSE}, default). \cr

\code{ns} \tab
An optional namespace created by \code{\link[shiny:NS]{shiny::NS()}}. Useful when using
\code{filterInput()} on a data.frame inside a \pkg{shiny} module.

}

Remaining arguments passed to \code{...} are passed to the \code{\link[=args_filter_input]{args_filter_input()}}
or the selected input function.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)

ui <- fluidPage(
	 sidebarLayout(
		 sidebarPanel(
			 #############################################
			 # Create a filterInput() inside a shiny app:
			 filterInput(
				x = letters,
				id = "letter",
				label = "Pick a letter:"
			 )
			 #############################################
		 ),
		 mainPanel(
			 textOutput("selected_letter")
		 )
	 )
)

server <- function(input, output, session) {
	 output$selected_letter <- renderText({
		 paste("You selected:", input$letter)
	 })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
