% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanban.R
\name{kanban-shiny}
\alias{kanban-shiny}
\alias{kanbanOutput}
\alias{renderKanban}
\title{Shiny bindings for Kanban Board}
\usage{
kanbanOutput(outputId, width = "100\%", height = "400px")

renderKanban(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read the value from}

\item{width, height}{A valid CSS unit (like \code{"100\%"}, \code{"400px"}, \code{"auto"})
or a number, which will be coerced to a string and have \code{"px"} appended.}

\item{expr}{An expression that generates kanban board with shinykanban::kanban()}

\item{env}{The parent environment for the reactive expression.}

\item{quoted}{If it is TRUE, then the quote()ed value of expr will be used when expr is evaluated.}
}
\value{
\code{kanbanOutput()} returns a \code{kanban} output element that can be
included in a Shiny UI.

\code{renderKanban()} returns a \code{kanban} render function that can be
assigned to a Shiny output slot.
}
\description{
Output and render functions for using Kanban Board within Shiny.
}
\examples{
if(interactive()){
library(shiny)
library(shinykanban)
library(bsicons)

ui <- fluidPage(
 kanbanOutput("kanban_board")
)

server <- function(input, output, session) {

 kanban_data <- reactiveVal(
  list(
  "To Do" = list(
    name = "To Do",
    items = list(
     list(
       id = "task1",
       title = "Task 1",
       subtitle = "abc"
     ),
      list(
       id = "task2",
       title = "Task 2"
     )
   ),
    listPosition = 1
   ),
  "In Progress" = list(
   name = "In Progress",
   items = list(
     list(
      id = "task3",
      title = "Task 3"
    )
   ),
     listPosition = 2
    )
   ))

 output$kanban_board <- renderKanban({
  kanban(data = kanban_data())
 })

 # Get any change from kanban and update the data
 observeEvent(input$kanban_board, {
 new_list <- input$kanban_board
 new_list$`_timestamp` <- NULL
    kanban_data(new_list)
 })
}
shinyApp(ui, server)
}
}
