% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfiles.R
\docType{data}
\name{appStitching}
\alias{appStitching}
\title{Sample data for the shinymgr.sqlite table, "appStitching"}
\format{
A data frame with 30 observations on the following 6 variables.
}
\usage{
data(demo_data)
}
\description{
Sample data imported to the shinymgr SQLite database
 by the function \code{\link{shiny_db_populate}}.
}
\details{
-----------------------------------------------------------

appSTitching records are added to the shinymgr.sqlite database 
via the "App Builder" interface within shinymgr's Developer section.
}
\section{Fields}{

\describe{
\item{\code{pkStitchID}}{Auto-number primary key.}

\item{\code{fkAppName}}{References pkAppName in the "apps" table.}

\item{\code{fkInstanceID}}{References pkInstanceID in the "tabModules" table.}

\item{\code{fkModArgID}}{Reference pkModArgID in the "modFunctionArguments" table.}

\item{\code{fkModReturnID}}{Reference pkModReturnID in the "modFunctionReturns" 
table.}

\item{\code{fkStitchID}}{References the stitch that preceeds a given stitch 
(record).}
}}

\examples{

# read in the demo data
data("demo_data")

# look at the structure
str(appStitching)

}
\seealso{
Other data: 
\code{\link{appReports}},
\code{\link{appTabs}},
\code{\link{apps}},
\code{\link{modFunctionArguments}},
\code{\link{modFunctionReturns}},
\code{\link{modPackages}},
\code{\link{modules}},
\code{\link{reports}},
\code{\link{tabModules}},
\code{\link{tabs}}
}
\concept{data}
