% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mod_info.R
\name{check_mod_info}
\alias{check_mod_info}
\title{Compares mod header information to the database}
\usage{
check_mod_info(modName, shinyMgrPath, verbose = TRUE)
}
\arguments{
\item{modName}{The name of the module}

\item{shinyMgrPath}{The path to the shinymgr folder.}

\item{verbose}{Whether to print updates to the console (default = TRUE)}
}
\value{
A list containing dataframes of logicals indicating whether fields are 
consistent between the module script header and the database. These include:
  1. Data for the modules table
  2. Data for the modFunctionArguments table
  3. Data for the modFunctionReturns table
A value of TRUE indicates that the fields match, and FALSE indicates a mismatch.
}
\description{
This function checks that mod header information matches what's in
the database to ensure that modules will be called and stitched correctly.
}
\section{More Info}{

The check_mod_info() function is described in the "shinymgr_modules" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{

# establish shinyMgrPath
parentPath <- tempdir()
shinyMgrPath <- paste0(parentPath, '/shinymgr')

# Create a demo database
shinymgr_setup(parentPath = parentPath, demo = TRUE)

#check info for different modules
check_mod_info(modName = "subset_rows", shinyMgrPath = shinyMgrPath)
  
check_mod_info(modName = "add_noise", shinyMgrPath = shinyMgrPath)
  
# Remove demo database
unlink(shinyMgrPath, recursive = TRUE)

}
\seealso{
Other module: 
\code{\link{mod_header_parser}()},
\code{\link{mod_init}()},
\code{\link{mod_register}()}
}
\concept{module}
