% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payload.R
\name{payload_endpoint_url}
\alias{payload_endpoint_url}
\title{Generate the absolute URL for the payload endpoint}
\usage{
payload_endpoint_url(session, path = "/ingress")
}
\arguments{
\item{session}{The Shiny session object}

\item{path}{The URL path (default "/ingress")}
}
\value{
A character string containing the complete URL (including protocol,
hostname, port, and path) where POST requests should be sent to reach
this endpoint.
}
\description{
Generate the absolute URL for the payload endpoint
}
\examples{
if (interactive()) {
server <- function(input, output, session) {
  url <- payload_endpoint_url(session, "/data")
  print(paste("Send POST requests to:", url))
}
}
}
