% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinystan-package.R
\docType{package}
\name{shinystan-package}
\alias{shinystan-package}
\title{\pkg{shinystan} R package ('ShinyStan' graphical user interface)}
\description{
\if{html}{
  \figure{logo.svg}{options: width="50" alt="mc-stan.org"}
  \emph{Stan Development Team}
}

Applied Bayesian data analysis is primarily implemented through the Markov
chain Monte Carlo (MCMC) algorithms offered by various software packages.
When analyzing a posterior sample obtained by one of these algorithms the
first step is to check for signs that the chains have converged to the target
distribution and and also for signs that the algorithm might require tuning
or might be ill-suited for the given model. There may also be theoretical
problems or practical inefficiencies with the specification of the model. The
ShinyStan app provides interactive plots and tables helpful for analyzing a
posterior sample, with particular attention to identifying potential problems
with the performance of the MCMC algorithm or the specification of the model.
ShinyStan is powered by the Shiny web application framework by RStudio
(\url{https://shiny.posit.co/}) and works with the output of MCMC programs
written in any programming language (and has extended functionality for
models fit using the \pkg{rstan} package and the No-U-Turn sampler).
}
\section{ShinyStan has extended functionality for Stan models}{


Stan (\url{https://mc-stan.org/}) models can be run in \R using the
\pkg{\link[rstan]{rstan}} package. Other packages like
\pkg{\link[rstanarm]{rstanarm}} and \pkg{brms} provide
higher-level interfaces to Stan that use \pkg{rstan} internally.
}

\section{Saving and sharing}{


  The \pkg{shinystan} package allows you to store the basic components of an
  entire project (code, posterior samples, graphs, tables, notes) in a single
  object, a \code{\link[=as.shinystan]{shinystan object}} (sso, for short).
  Users can save many of the plots as \pkg{ggplot2} objects for further
  customization and easy integration in reports or post-processing for
  publication.

  The \code{\link{deploy_shinystan}} function lets you easily deploy your own
  ShinyStan apps online for any of your models using the shinyapps.io
  service from 'RStudio'. Each of your apps (each of your models) will have a
  unique url and will be compatible with most web browsers.
}

\section{License}{


 The \pkg{shinystan} package is open source licensed under the GNU Public
 License, version 3 (GPLv3).
}

\section{Demo}{


 Check out the demo using \code{\link{launch_shinystan_demo}} or try it with
 one of your own models using \code{\link{launch_shinystan}}.
}

\section{Resources}{

\itemize{
 \item Web page with online documentation
   (\url{https://mc-stan.org/shinystan/})
 \item Stan Forums on Discourse (\url{https://discourse.mc-stan.org})
 \item GitHub issue tracker (\url{https://github.com/stan-dev/shinystan/issues})
}
}

\references{
Muth, C., Oravecz, Z., and Gabry, J. (2018)
User-friendly Bayesian regression modeling: A tutorial with rstanarm and shinystan.
\emph{The Quantitative Methods for Psychology}. 14(2), 99--119.
\url{https://www.tqmp.org/RegularArticles/vol14-2/p099/p099.pdf}

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
  Gelman, A. (2019), Visualization in Bayesian workflow.
  *J. R. Stat. Soc. A*, 182: 389-402. doi:10.1111/rssa.12378
  ([journal version](https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378),
   [preprint arXiv:1709.01449](https://arxiv.org/abs/1709.01449),
   [code on GitHub](https://github.com/jgabry/bayes-vis-paper))
}
\seealso{
\code{\link{as.shinystan}} for creating \code{shinystan} objects.

\code{\link{launch_shinystan_demo}} to try a demo.

\code{\link{launch_shinystan}} to launch the 'ShinyStan' interface 
  using a particular \code{shinystan} object.

Useful links:
\itemize{
  \item \url{https://mc-stan.org/shinystan/}
  \item \url{https://discourse.mc-stan.org}
  \item Report bugs at \url{https://github.com/stan-dev/shinystan/issues/}
}

}
\author{
\strong{Maintainer}: Jonah Gabry \email{jgabry@gmail.com}

Authors:
\itemize{
  \item Duco Veen
}

Other contributors:
\itemize{
  \item  Stan Development Team [contributor]
  \item Michael Andreae [contributor]
  \item Michael Betancourt [contributor]
  \item Bob Carpenter [contributor]
  \item Yuanjun Gao [contributor]
  \item Andrew Gelman [contributor]
  \item Ben Goodrich [contributor]
  \item Daniel Lee [contributor]
  \item Dongying Song [contributor]
  \item Rob Trangucci [contributor]
  \item Visruth Srimath Kandali [contributor]
}

}
