% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVP.R
\name{shrinkTVP}
\alias{shrinkTVP}
\title{Markov Chain Monte Carlo (MCMC) for time-varying parameter models with shrinkage}
\usage{
shrinkTVP(
  formula,
  data,
  mod_type = "double",
  niter = 10000,
  nburn = round(niter/2),
  nthin = 1,
  learn_a_xi = TRUE,
  learn_a_tau = TRUE,
  a_xi = 0.1,
  a_tau = 0.1,
  learn_c_xi = TRUE,
  learn_c_tau = TRUE,
  c_xi = 0.1,
  c_tau = 0.1,
  a_eq_c_xi = FALSE,
  a_eq_c_tau = FALSE,
  learn_kappa2_B = TRUE,
  learn_lambda2_B = TRUE,
  kappa2_B = 20,
  lambda2_B = 20,
  hyperprior_param,
  display_progress = TRUE,
  sv = FALSE,
  sv_param,
  MH_tuning,
  starting_vals
)
}
\arguments{
\item{formula}{object of class "formula": a symbolic representation of the model, as in the
function \code{lm}. For details, see \code{\link{formula}}.}

\item{data}{\emph{optional} data frame containing the response variable and the covariates. If not found in \code{data},
the variables are taken from \code{environment(formula)}, typically the environment from which \code{shrinkTVP}
is called. No \code{NA}s are allowed in the response variable and the covariates.}

\item{mod_type}{character string that reads either \code{"triple"}, \code{"double"} or \code{"ridge"}.
Determines whether the triple gamma, double gamma or ridge prior are used for \code{theta_sr} and \code{beta_mean}.
The default is "double".}

\item{niter}{positive integer, indicating the number of MCMC iterations
to perform, including the burn-in. Has to be larger than or equal to \code{nburn} + 2. The default value is 10000.}

\item{nburn}{non-negative integer, indicating the number of iterations discarded
as burn-in. Has to be smaller than or equal to \code{niter} - 2. The default value is \code{round(niter / 2)}.}

\item{nthin}{positive integer, indicating the degree of thinning to be performed. Every \code{nthin} draw is kept and returned.
The default value is 1, implying that every draw is kept.}

\item{learn_a_xi}{logical value indicating whether to learn a_xi, the spike parameter of the state variances.
Ignored if \code{mod_type} is set to \code{"ridge"}. The default value is \code{TRUE}.}

\item{learn_a_tau}{logical value indicating whether to learn a_tau, the spike parameter of the mean of the
initial values of the states. Ignored if \code{mod_type} is set to \code{"ridge"}. The default value is \code{TRUE}.}

\item{a_xi}{positive, real number, indicating the (fixed) value for a_xi. Ignored if
\code{learn_a_xi} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{a_tau}{positive, real number, indicating the (fixed) value for a_tau. Ignored if
\code{learn_a_tau} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{learn_c_xi}{logical value indicating whether to learn c_xi, the tail parameter of the state variances.
Ignored if \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_xi} is set to \code{TRUE}.
The default value is \code{TRUE}.}

\item{learn_c_tau}{logical value indicating whether to learn c_tau, the tail parameter of the mean of the
initial values of the states. Ignored if \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_tau} is set to \code{TRUE}.
The default value is \code{TRUE}.}

\item{c_xi}{positive, real number, indicating the (fixed) value for c_xi. Ignored if
\code{learn_c_xi} is \code{TRUE}, \code{mod_type} is not set to \code{"triple"} or \code{a_eq_c_xi} is set to \code{TRUE}.
The default value is 0.1.}

\item{c_tau}{positive, real number, indicating the (fixed) value for c_tau. Ignored if
\code{learn_c_xi} is \code{TRUE}, \code{mod_type} is not set to \code{"triple"}  or \code{a_eq_c_tau} is set to \code{TRUE}.
The default value is 0.1.}

\item{a_eq_c_xi}{logical value indicating whether to force \code{a_xi} and \code{c_xi} to be equal.
If set to \code{TRUE}, \code{beta_a_xi} and \code{alpha_a_xi} are used as the hyperparameters and \code{beta_c_xi} and \code{alpha_c_xi} are ignored.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{a_eq_c_tau}{logical value indicating whether to force \code{a_tau} and \code{c_tau} to be equal.
If set to \code{TRUE}, \code{beta_a_tau} and \code{alpha_a_tau} are used as the hyperparameters and \code{beta_c_tau} and \code{alpha_c_tau} are ignored.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{learn_kappa2_B}{logical value indicating whether to learn kappa2_B, the global level of shrinkage for
the state variances. The default value is \code{TRUE}.}

\item{learn_lambda2_B}{logical value indicating whether to learn the lambda2_B parameter,
the global level of shrinkage for the mean of the initial values of the states. The default value is \code{TRUE}.}

\item{kappa2_B}{positive, real number, indicating the (fixed) value for kappa2_B. Ignored if
\code{learn_kappa2_B} is \code{TRUE}. The default value is 20.}

\item{lambda2_B}{positive, real number, indicating the (fixed) value for lambda2_B. Ignored if
\code{learn_lambda2_B} is \code{TRUE}. The default value is 20.}

\item{hyperprior_param}{\emph{optional} named list containing hyperparameter values.
Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
All hyperparameter values have to be positive, real numbers. The following hyperparameters can be
supplied:
\itemize{
\item \code{c0}: The default value is 2.5.
\item \code{g0}: The default value is 5.
\item \code{G0}: The default value is 5 / (2.5 - 1).
\item \code{e1}: The default value is 0.001.
\item \code{e2}: The default value is 0.001.
\item \code{d1}: The default value is 0.001.
\item \code{d2}: The default value is 0.001.
\item \code{alpha_a_xi}: The default value is 5.
\item \code{alpha_a_tau}: The default value is 5.
\item \code{beta_a_xi}: The default value is 10.
\item \code{beta_a_tau}: The default value is 10.
\item \code{alpha_c_xi}: The default value is 5.
\item \code{alpha_c_tau}: The default value is 5.
\item \code{beta_c_xi}: The default value is 2.
\item \code{beta_c_tau}: The default value is 2.
}}

\item{display_progress}{logical value indicating whether the progress bar and other informative output should be
displayed. The default value is \code{TRUE}.}

\item{sv}{logical value indicating whether to use stochastic volatility for the error of the observation
equation. For details please see \code{\link[stochvol]{stochvol}}, in particular \code{\link[stochvol]{svsample}}. The default value is
\code{FALSE}.}

\item{sv_param}{\emph{optional} named list containing hyperparameter values for the stochastic volatility
parameters. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown. Ignored if
\code{sv} is \code{FALSE}. The following elements can be supplied:
\itemize{
\item \code{Bsigma_sv}: positive, real number. The default value is 1.
\item \code{a0_sv}: positive, real number. The default value is 5.
\item \code{b0_sv}: positive, real number. The default value is 1.5.
\item \code{bmu}: real number. The default value is 0.
\item \code{Bmu}: real number. larger than 0. The default value is 1.
}}

\item{MH_tuning}{\emph{optional} named list containing values used to tune the MH steps for \code{a_xi}, \code{a_tau},
\code{c_xi}, and \code{c_tau}. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
The arguments for \code{a_xi}(\code{a_tau}) are only used if \code{learn_a_xi}(\code{learn_a_tau})
is set to \code{TRUE} and \code{mod_type} is not equal to \code{"ridge"}. The arguments for \code{c_xi}(\code{c_tau}) are only
used if \code{learn_c_xi}(\code{learn_c_tau}) is set to \code{TRUE} and \code{mod_type} is equal to \code{"triple"}. Arguments ending in "adaptive" are
logical values indicating whether or not to make the MH step for the respective parameter adaptive. Arguments ending in "tuning_par" serve two different purposes.
If the respective MH step is not set to be adaptive, it acts as the standard deviation of the proposal distribution. If the respective MH step
is set to be adaptive, it acts as the initial standard deviation. Arguments ending in "target_rate" define the acceptance rate the algorithm aims to achieve.
Arguments ending in "max_adapt" set the maximum value by which the logarithm of the standard deviation of the proposal distribution is adjusted. Finally,
arguments ending in "batch_size" set the batch size after which the standard deviation of the proposal distribution is adjusted.
The following elements can be supplied:
\itemize{
\item \code{a_xi_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_xi_tuning_par}: positive, real number. The default value is 1.
\item \code{a_xi_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_xi_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_xi_batch_size}: positive integer. The default value is 50.
\item \code{a_tau_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_tau_tuning_par}: positive, real number. The default value is 1.
\item \code{a_tau_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_tau_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_tau_batch_size}: positive integer. The default value is 50.
\item \code{c_xi_adaptive}: logical value. The default is \code{TRUE}.
\item \code{c_xi_tuning_par}: positive, real number. The default value is 1.
\item \code{c_xi_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{c_xi_max_adapt}: positive, real number. The default value is 0.01.
\item \code{c_xi_batch_size}: positive integer. The default value is 50.
\item \code{c_tau_adaptive}: logical value. The default is \code{TRUE}.
\item \code{c_tau_tuning_par}: positive, real number. The default value is 1.
\item \code{c_tau_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{c_tau_max_adapt}: positive, real number. The default value is 0.01.
\item \code{c_tau_batch_size}: positive integer. The default value is 50.
}}

\item{starting_vals}{\emph{optional} named list containing the values at which the MCMC algorithm will be initialized. In the
following \code{d} refers to the number of covariates, including the intercept and expanded factors.
Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown. The following elements can be supplied:
\itemize{
\item \code{beta_mean_st}: vector of length \code{d} containing single numbers. The default is \code{rep(0, d)}.
\item \code{theta_sr_st}: vector of length \code{d} containing single, positive numbers. The default is \code{rep(1, d)}.
\item \code{tau2_st}: vector of length \code{d} containing single, positive numbers. The default is \code{rep(1, d)}.
\item \code{xi2_st}: vector of length \code{d} containing single, positive numbers. The default is \code{rep(1, d)}.
\item \code{kappa2_st}: vector of length \code{d} containing single, positive numbers. The default is \code{rep(1, d)}.
\item \code{lambda2_st}: vector of length \code{d} containing single, positive numbers. The default is \code{rep(1, d)}.
\item \code{kappa2_B_st}: positive, real number. The default value is 20.
\item \code{lambda2_B_st}: positive, real number. The default value is 20.
\item \code{a_xi_st}: positive, real number. The default value is 0.1.
\item \code{a_tau_st}: positive, real number. The default value is 0.1.
\item \code{c_xi_st}: positive, real number. The default value is 0.1. Note that the prior for \code{c_xi} is restricted to (0, 0.5).
\item \code{c_tau_st}: positive, real number. The default value is 0.1. Note that the prior for \code{c_tau} is restricted to (0, 0.5).
\item \code{sv_mu_st}: real number. The default value is -10.
\item \code{sv_phi_st}: positive, real number between -1 and 1. The default value is 0.5.
\item \code{sv_sigma2_st }: positive, real number. The default value is 1.
\item \code{C0_st}: positive, real number. The default value is 1.
\item \code{sigma2_st}: positive, real number if \code{sv} is \code{FALSE}, otherwise a vector of positive, real numbers of length \code{N}. The default value is 1 or a vector thereof.
\item \code{h0_st}: real number. The default value is 0.
}}
}
\value{
The value returned is a list object of class \code{shrinkTVP} containing
\item{\code{beta}}{\code{list} object containing an \code{mcmc.tvp} object for the parameter draws from the posterior distribution of the centered
states, one for each covariate. In the case that there is only one covariate, this becomes just a single \code{mcmc.tvp} object.}
\item{\code{beta_mean}}{\code{mcmc} object containing the parameter draws from the posterior distribution of beta_mean.}
\item{\code{theta_sr}}{\code{mcmc} object containing the parameter draws from the posterior distribution of the square root of theta.}
\item{\code{tau2}}{\code{mcmc} object containing the parameter draws from the posterior distribution of tau2.}
\item{\code{xi2}}{\code{mcmc} object containing the parameter draws from the posterior distribution of xi2.}
\item{\code{lambda2}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of lambda2.
Not returned if \code{mod_type} is not \code{"triple"}.}
\item{\code{kappa2}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of kappa2.
Not returned if \code{mod_type} is not \code{"triple"}.}
\item{\code{a_xi}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of a_xi.
Not returned if \code{learn_a_xi} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{a_tau}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of a_tau.
Not returned if \code{learn_a_tau} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{c_xi}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of c_xi.
Not returned if \code{learn_c_xi} is \code{FALSE} or \code{mod_type} is not \code{"triple"}.}
\item{\code{c_tau}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of c_tau.
Not returned if \code{learn_c_tau} is \code{FALSE} or \code{mod_type} is not \code{"triple"}.}
\item{\code{lambda2_B}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of lambda2_B.
Not returned if \code{learn_lambda2_B} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{kappa2_B}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of kappa2_B.
Not returned if \code{learn_kappa2_B} is \code{FALSE} or \code{mod_type} is \code{"ridge"}.}
\item{\code{sigma2}}{\code{mcmc} object containing the parameter draws from the posterior distribution of \code{sigma2}.
If \code{sv} is \code{TRUE}, \code{sigma2} is additionally an \code{mcmc.tvp} object.}
\item{\code{C0}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of C0.
Not returned if \code{sv} is \code{TRUE}.}
\item{\code{sv_mu}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of the mu
parameter for the stochastic volatility model on the errors. Not returned if \code{sv} is \code{FALSE}.}
\item{\code{sv_phi}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of the phi
parameter for the stochastic volatility model on the errors. Not returned if \code{sv} is \code{FALSE}.}
\item{\code{sv_sigma2}}{\emph{(optional)} \code{mcmc} object containing the parameter draws from the posterior distribution of the sigma2
parameter for the stochastic volatility model on the errors. Not returned if \code{sv} is \code{FALSE}.}
\item{\code{MH_diag}}{\emph{(optional)} named list containing statistics for assessing MH performance. Not returned if no MH steps are required
or none of them are specified to be adaptive.}
\item{\code{internals}}{\code{list} object containing two arrays that are required for calculating the LPDS.}
\item{\code{priorvals}}{\code{list} object containing hyperparameter values of the prior distributions, as specified by the user.}
\item{\code{model}}{\code{list} object containing the model matrix, model response and formula used.}
\item{\code{summaries}}{\code{list} object containing a collection of summary statistics of the posterior draws.}

To display the output, use \code{plot} and \code{summary}. The \code{summary} method displays the specified prior values stored in
\code{priorvals} and the posterior summaries stored in \code{summaries}, while the \code{plot} method calls \code{coda}'s \code{plot.mcmc}
or the \code{plot.mcmc.tvp} method. Furthermore, all functions that can be applied to \code{coda::mcmc} objects
(e.g. \code{coda::acfplot}) can be applied to all output elements that are \code{coda} compatible.
}
\description{
\code{shrinkTVP} samples from the joint posterior distribution of the parameters of a time-varying
parameter model with shrinkage, potentially including stochastic volatility (SV), and returns the MCMC draws.
}
\details{
For details concerning the algorithms please refer to the papers by Bitto and Frühwirth-Schnatter (2019) and Cadonna et al. (2020).
For more details on the package and the usage of the functions, see Knaus et al. (2021). For the multivariate extension,
see the \code{\link[shrinkTVPVAR]{shrinkTVPVAR}} function from the \code{shrinkTVPVAR} package.
}
\examples{
\donttest{

## Example 1, learn everything
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

res <- shrinkTVP(y ~ x1 + x2, data = data)
# summarize output
summary(res)


## Example 2, hierarchical Bayesian Lasso
res <- shrinkTVP(y ~ x1 + x2, data = data,
                learn_a_xi = FALSE, learn_a_tau = FALSE,
                a_xi = 1, a_tau = 1)


## Example 3, non-hierarchical Bayesian Lasso
res <- shrinkTVP(y ~ x1 + x2, data = data,
                learn_a_xi = FALSE, learn_a_tau = FALSE,
                a_xi = 1, a_tau = 1,
                learn_kappa2 = FALSE, learn_lambda2 = FALSE)


## Example 4, adding stochastic volatility
res <- shrinkTVP(y ~ x1 + x2, data = data,
                sv = TRUE)


## Example 4, changing some of the default hyperparameters
res <- shrinkTVP(y ~ x1 + x2, data = data,
                hyperprior_param = list(beta_a_xi = 5,
                                        alpha_a_xi = 10))

## Example 5, using the triple gamma prior
res <- shrinkTVP(y ~ x1 + x2, data = data,
                mod_type = "triple")
}

}
\references{
Bitto, A., & Frühwirth-Schnatter, S. (2019). "Achieving shrinkage in a time-varying parameter model framework."
\emph{Journal of Econometrics}, 210(1), 75-97. <doi:10.1016/j.jeconom.2018.11.006>

Cadonna, A., Frühwirth-Schnatter, S., & Knaus, P. (2020). "Triple the Gamma—A Unifying Shrinkage Prior for Variance and Variable Selection in Sparse State Space and TVP Models."
\emph{Econometrics}, 8(2), 20. <doi:10.3390/econometrics8020020>

Knaus, P., Bitto-Nemling, A., Cadonna, A., & Frühwirth-Schnatter, S. (2021) "Shrinkage in the Time-Varying Parameter Model Framework Using the \code{R} Package \code{shrinkTVP}."
\emph{Journal of Statistical Software} 100(13), 1–32. <doi:10.18637/jss.v100.i13>
}
\seealso{
\code{\link{plot.shrinkTVP}}, \code{\link{plot.mcmc.tvp}}, \code{\link[shrinkTVPVAR]{shrinkTVPVAR}}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
