% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sieve.R
\name{ggplot_sieve}
\alias{ggplot_sieve}
\title{Plotting Univariate Mark-Specific Proportional Hazards Model Fits Using \code{ggplot}}
\usage{
ggplot_sieve(
  x,
  mark = NULL,
  tx = NULL,
  xlim = NULL,
  ylim = NULL,
  xtickAt = NULL,
  xtickLab = NULL,
  ytickAt = NULL,
  ytickLab = NULL,
  tickLabSize = 14,
  xlab = NULL,
  ylab = NULL,
  axisLabSize = 15,
  title = NULL,
  titleSize = 16,
  subtitle = NULL,
  subtitleSize = 10,
  txLab = c("Placebo", "Treatment"),
  txLabSize = 5,
  legendLabSize = 12,
  legendPosition = c(0.96, 1.08),
  legendJustification = c(1, 1),
  estLineSize = 1.6,
  ciLineSize = 1.2,
  boxplotWidth = 0.8,
  jitterFactor = 0.1,
  jitterSeed = 0,
  pointColor = c("blue", "red3"),
  pointSize = 1.7,
  bottomPlotMargin = c(-0.5, 0.3, 0, 0),
  topPlotMargin = c(0, 0.3, -0.12, 1.83),
  plotHeights = c(0.33, 0.67)
)
}
\arguments{
\item{x}{an object returned by \code{\link{summary.sievePH}} or \code{\link{summary.kernel_sievePH}}}

\item{mark}{a numeric vector specifying a univariate continuous mark. For subjects with a right-censored time-to-event, the value(s) in \code{mark} should be set to \code{NA}.}

\item{tx}{a numeric vector indicating the treatment group (1 if treatment, 0 if placebo)}

\item{xlim}{a numeric vector of length 2 specifying the x-axis range (\code{NULL} by default)}

\item{ylim}{a numeric vector of length 2 specifying the y-axis range (\code{NULL} by default)}

\item{xtickAt}{a numeric vector specifying the position of x-axis tickmarks (\code{NULL} by default)}

\item{xtickLab}{a numeric vector specifying labels for tickmarks listed in \code{xtickAt}. If \code{NULL} (default), the labels are determined by \code{xtickAt}.}

\item{ytickAt}{a numeric vector specifying the position of y-axis tickmarks (\code{NULL} by default)}

\item{ytickLab}{a numeric vector specifying labels for tickmarks listed in \code{ytickAt}. If \code{NULL} (default), the labels are determined by \code{ytickAt}.}

\item{tickLabSize}{a numeric value specifying the font size of tickmark labels along both axes in the bottom panel (\code{14} by default)}

\item{xlab}{a character string specifying the x-axis label (\code{NULL} by default)}

\item{ylab}{a character string specifying the y-axis label (\code{NULL} by default)}

\item{axisLabSize}{a numeric value specifying the font size of both axis labels in the bottom panel (\code{15} by default)}

\item{title}{a character string specifying the plot title (\code{NULL} by default)}

\item{titleSize}{a numeric value specifying the font size of the plot title (\code{16} by default)}

\item{subtitle}{a character string specifying the plot subtitle (\code{NULL} by default)}

\item{subtitleSize}{a numeric value specifying the font size of the plot subtitle (\code{10} by default)}

\item{txLab}{a character vector of length 2 specifying the placebo and treatment labels (in this order). The default labels are \code{placebo} and \code{treatment}.}

\item{txLabSize}{a numeric value specifying the font size of labels \code{txLab} (\code{5} by default)}

\item{legendLabSize}{a numeric value specifying the font size of legend labels in the bottom panel (\code{11} by default)}

\item{legendPosition}{a numeric vector of length 2 specifying the position of the legend in the bottom panel (\code{c(0.96, 1.08)} by default), passed on to argument \code{legend.position} in \code{theme()}}

\item{legendJustification}{a numeric vector of length 2 specifying the justification of the legend in the bottom panel (\code{c(1, 1)} by default), passed on to argument \code{legend.justification} in \code{theme()}}

\item{estLineSize}{a numeric value specifying the line width for the point estimate of the mark-specific treatment effect (\code{1.6} by default)}

\item{ciLineSize}{a numeric value specifying the line width for the confidence limits for the mark-specific treatment effect (\code{1.2} by default)}

\item{boxplotWidth}{a numeric value specifying the width of each box in the box plot (\code{0.8}) by default}

\item{jitterFactor}{a numeric value specifying the amount of vertical jitter (\code{0.1} by default)}

\item{jitterSeed}{a numeric value setting the seed of R's random number generator for jitter in the scatter plot (\code{0} by default)}

\item{pointColor}{a character vector of length 2 color-coding the placebo and treatment group (in this order) in the scatter plot (\code{c("blue", "red3")} by default)}

\item{pointSize}{a numeric value specifying the size of data points in the scatter plot (\code{1.7} by default)}

\item{bottomPlotMargin}{a numeric vector, using cm as the unit, passed on to argument \code{plot.margin} in \code{theme()} for the bottom panel (\code{c(-0.5, 0.3, 0, 0)} by default)}

\item{topPlotMargin}{a numeric vector, using \code{"lines"} as the unit, passed on to argument \code{plot.margin} in \code{theme()} for the top panel (\code{c(0, 0.3, -0.12, 1.83)} by default)}

\item{plotHeights}{a numeric vector specifying relative heights of the top and bottom panels (\code{c(0.33, 0.67)} by default) passed on to argument \code{heights} in \code{ggpubr::ggarrange()}}
}
\value{
A \code{ggplot} object.
}
\description{
\code{ggplot}-style plotting for univariate marks. Point and interval estimates of the mark-specific treatment effect parameter specified by component 
\code{contrast} in \code{\link{summary.sievePH}} or \code{\link{summary.kernel_sievePH}} are plotted, together with scatter and box plots of the observed mark values by treatment.
}
\examples{
n <- 200
tx <- rep(0:1, each=n/2)
tm <- c(rexp(n/2, 0.2), rexp(n/2, 0.2 * exp(-0.4)))
cens <- runif(n, 0, 15)
eventTime <- pmin(tm, cens, 3)
eventInd <- as.numeric(tm <= pmin(cens, 3))
mark <- ifelse(eventInd==1, c(rbeta(n/2, 2, 5), rbeta(n/2, 2, 2)), NA)
markRng <- range(mark, na.rm=TRUE)

# fit a model with a univariate mark using the sievePH method
fit1 <- sievePH(eventTime, eventInd, mark, tx)
sfit1 <- summary(fit1, markGrid=seq(markRng[1], markRng[2], length.out=10))
print(ggplot_sieve(sfit1, mark, tx))

# fit a model with a univariate mark using the kernel_sievePH method
fit2 <- kernel_sievePH(eventTime, eventInd, mark, tx,
                      tau = 3, tband = 0.5, hband = 0.3, nvgrid = 20, 
                      nboot = NULL)
sfit2 <- summary(fit2)
print(ggplot_sieve(sfit2, mark, tx))

}
\seealso{
\code{\link{plot.summary.sievePH}}, \code{\link{sievePH}}, \code{\link{summary.sievePH}}, \code{\link{kernel_sievePH}}, \code{\link{summary.kernel_sievePH}}
}
