% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_log_normal_model.R
\name{sample_log_normal_model}
\alias{sample_log_normal_model}
\title{Sample log normal model(s) with parameters according to priors}
\usage{
sample_log_normal_model(
  number_of_contributors,
  sampling_parameters,
  model_settings
)
}
\arguments{
\item{number_of_contributors}{Integer}

\item{sampling_parameters}{List. Needs to contain:
\itemize{
\item min_template. Numeric of length one.
\item max_template. Numeric of length one.
\item degradation_shape. Numeric of length one.
\item degradation_scale. Numeric of length one.
}}

\item{model_settings}{List. See \link{log_normal_model}.}
}
\value{
When \code{length(number_of_contributors)==1}, a single \link{log_normal_model} of class \code{pg_model}. Otherwise, a list of these.
}
\description{
Sample log normal model(s) with parameters according to priors
}
\details{
In simulation studies involving many mixed DNA profiles, one often needs to generate various samples with different model parameters. This function samples a log normal model with parameters according to prior distributions. The template parameter for each contributor is sampled uniformly between \code{min_template} and \code{max_template}. The degradation parameter for each contributor is sampled from a gamma distribution with parameters \code{degradation_shape} and \code{degradation_scale}.
}
\examples{
gf <- gf_configuration()

sampling_parameters <- list(min_template = 50., max_template = 1000.,
                            degradation_shape = 2.5, degradation_scale = 1e-3)

model_no_stutter <- sample_log_normal_model(number_of_contributors = 1,
                                            sampling_parameters = sampling_parameters,
                                            model_settings = gf$log_normal_settings)
}
