% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Single_Kc.R
\name{cal_Kcmid_for_singleKc}
\alias{cal_Kcmid_for_singleKc}
\title{Crop coefficient for the mid-season stage}
\usage{
cal_Kcmid_for_singleKc(RHmine, u2e, Ktable, he)
}
\arguments{
\item{RHmine}{mean value for daily minimum relative humidity during the mid-season
growth stage , for 20 <= RHmine <= 80}

\item{u2e}{mean value for daily wind speed at 2 m height over grass during the mid-
season growth stage (mls), for 1  <= u2e <= 6}

\item{Ktable}{value for Kc mid taken from Table 12}

\item{he}{mean plant height during the mid-season stage [m] for 0.1 m < h < 10 m}
}
\value{
A value for Kcmid value
}
\description{
Typical values for the crop coefficient at the end of the late season growth stage, Kc end, are
 listed in Table 12 for various agricultural crops.For specific adjustment in climates where RHmin differs from 45 \% or where u2 is larger or
 smaller than 2.0 m/s.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
