% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_airVaporPressureDeficit_meanCanopyflow}
\alias{cal_airVaporPressureDeficit_meanCanopyflow}
\title{Calculating air vapor pressure deficit at the mean canopy}
\usage{
cal_airVaporPressureDeficit_meanCanopyflow(
  D,
  r_a_a,
  rho_cp = 1221.09,
  DELTA,
  A,
  gamma = 0.658,
  lambda_ET
)
}
\arguments{
\item{D}{the vapor pressure deficit (mbar)}

\item{r_a_a}{the aerodynamic resistance between the mean canopy flow and reference height (s m-1)}

\item{rho_cp}{the volumetric heat capacity for air (1221.09 J m-3 K-1)}

\item{DELTA}{is the slope of the saturated vapor pressure curve (mbar K-1)}

\item{A}{is the total energy available to the system (W m-2 ground)}

\item{gamma}{psychometric constant (0.658 mbar K-1 )}

\item{lambda_ET}{the total latent heat flux (W m-2 ground)}
}
\value{
A vector for the vapor pressure deficit at the mean canopy flow (mbar)
}
\description{
Calculating air vapor pressure deficit at the mean canopy
}
\note{
Knowing D0 is essential because this value is used to calculate the latent and sensible heat fluxes for the soil and
   crop components.
}
