% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_latentHeatFluxesForCrop}
\alias{cal_latentHeatFluxesForCrop}
\title{Calculating latent heat fluxes for crop}
\usage{
cal_latentHeatFluxesForCrop(DELTA, Ac, rho_cp, D0, r_c_a, gamma, r_c_s)
}
\arguments{
\item{DELTA}{the slope of the saturated vapor pressure curve (mbar K-1)}

\item{Ac}{energy available to the crop (W m-2 ground)}

\item{rho_cp}{the volumetric heat capacity for air (1221.09 J m-3 K-1)}

\item{D0}{the vapor pressure deficit at the mean canopy flow}

\item{r_c_a}{is the bulk boundary layer resistance (s m-1)}

\item{gamma}{is the psychometric constant (0.658 mbar K-1)}

\item{r_c_s}{the canopy resistance (s m-1)}
}
\value{
A vector for latent heat fluxes for crop (W m-2 ground)
}
\description{
Calculating latent heat fluxes for crop
}
