% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotonic_regression.R
\name{isotonic_regression}
\alias{isotonic_regression}
\title{Isotonic Regression for Toxicity Rate Estimation}
\usage{
isotonic_regression(n_pts_mat, n_tox_mat)
}
\arguments{
\item{n_pts_mat}{Numeric matrix of size n_trials x n_doses. Number of patients treated at
each dose level for each trial.}

\item{n_tox_mat}{Numeric matrix of size n_trials x n_doses. Number of dose-limiting toxicities
(DLTs) observed at each dose level for each trial.}
}
\value{
Numeric matrix of size n_trials x n_doses. Isotonic regression estimates of
toxicity rates at each dose for each trial. Values are NA for untreated
doses (n_pts = 0).
}
\description{
Apply isotonic regression to estimate toxicity rates under the monotonicity
constraint (toxicity increases with dose) using the Pool Adjacent Violators
Algorithm (PAVA).
}
\details{
Pseudocounts (0.05 for toxicity, 0.1 for total patients) are added before
estimation, reflecting a Beta-Binomial prior. PAVA is applied independently
per trial using weighted pooling to enforce monotonicity: dose-toxicity
relationships must be non-decreasing across dose levels.
}
\examples{
# Example 1: Single trial
n_pts_single <- matrix(c(3, 6, 9, 12), nrow = 1)
n_tox_single <- matrix(c(0, 1, 3, 4), nrow = 1)

iso_est <- isotonic_regression(n_pts_single, n_tox_single)
print(iso_est)

# Example 2: Multiple trials
n_pts_mat <- matrix(c(3, 6, 9, 12,
                      3, 6, 9, 12,
                      3, 6, 9, 12), nrow = 3, byrow = TRUE)
n_tox_mat <- matrix(c(0, 1, 3, 4,
                      0, 0, 2, 3,
                      1, 2, 4, 6), nrow = 3, byrow = TRUE)

iso_est <- isotonic_regression(n_pts_mat, n_tox_mat)
print(iso_est)

}
\references{
Liu, S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I
Clinical Trials. \emph{Journal of the Royal Statistical Society: Series C},
64, 507-523.
}
