% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effFit.R
\name{effFit}
\alias{effFit}
\alias{effContFit}
\alias{effDiscFit}
\title{Fit Effectiveness Distributions}
\usage{
effContFit(x, silent = TRUE)

effDiscFit(x, support, silent = TRUE)
}
\arguments{
\item{x}{a sample of effectiveness scores between 0 and 1.}

\item{silent}{logical: should the report of error messages be suppressed?}

\item{support}{the support of the distribution (see \code{\link{support}}).}
}
\value{
a list of \code{\link[=eff.cont-class]{eff.cont}} objects fitted to the given data.
}
\description{
Attempts to fit the distribution families listed in \code{\link{effCont}} or
\code{\link{effDisc}}. In the discrete case, the \code{\link[=effDisc_dks]{dks}} distribution is
fitted with multipliers 1, 2, 5 and 10. Failure to fit any distribution family results in an
error.
}
\examples{
e <- effContFit(web2010ap[,1])
str(e, 1)
sapply(e, plot, plot.data = TRUE)

e <- effDiscFit(web2010p20[,1], seq(0,1,.05))
str(e, 1)
sapply(e, plot, plot.data = TRUE)
}
\seealso{
\code{\link{effCont}} and \code{\link{effDisc}} for the available distribution families.

  See \code{\link{effSelect}} for model selection, and \code{\link{effFitAndSelect}} to fit and
  select automatically.
}
