% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CarlisleStouffer.R
\name{sim_distr}
\alias{sim_distr}
\title{Assessment of Data Trial Distributions According to the Carlisle-Stouffer Method}
\usage{
sim_distr(m, dataframe, plot_flag)
}
\arguments{
\item{m}{An integer specifying the number of Monte Carlo simulations to be run.}

\item{dataframe}{A dataframe with 9 columns with order and content as specified in the "Details" section.}

\item{plot_flag}{A logical indicating whether cumulative frequencies of p-values are to be plotted in a graph; if TRUE a plot is provided.}
}
\value{
\enumerate{
\item A dataframe with p-values for each variable in each assessed trial - each trial is displayed in a different row. For each trial, each variable ("V") is displayed in a different column; variables are listed in the same order they are presented in the original dataframe.
\item A dataframe with combined (overall) p-values for each assessed trial - each trial is displayed in a different row.
\item A graph plotting the cumulative frequency of obtained variable p-values (optional).
}
}
\description{
Assessment of the distributions of baseline continuous and categorical variables in randomised trials, assuming normal distributions for the former and binomial distributions for the latter. The method used is based on the Carlisle-Stouffer method with Monte Carlo simulations. It calculates p-values for each trial baseline variable, as well as combined p-values for each trial - these p-values measure how compatible are distributions of trials baseline variables with random sampling. This package also allows for graphically plotting the cumulative frequencies of obtained p-values.
}
\section{Details}{

The dataframe must necessarily have 9 columns with the following order and content:
\enumerate{
   \item Trial number: An integer that sequentially identifies the randomised trial from which data concern. Therefore, all rows with data from the first randomised trial should be identified with the number 1 in this first column, data from the second trial should be identified with number 2, etc.
   \item Variable number for each trial: An integer that sequentially identifies the different variables assessed within each trial. Therefore, for each trial, all rows with data from the first reported variable should be identified with the number 1, data from the second variable should be identified with number 2, etc.
   \item Group: An integer that sequentially identifies the different groups of participants for which each variable was assessed.
   \item Number of participants: An integer corresponding to the number of assessed individuals in each group.
   \item Reported mean value (continuous variables) or proportion (categorical variables): A number with the reported result (mean or proportion) obtained for the corresponding variable in each group. Proportions must NOT be presented as percentages.
   \item Reported standard-deviation: A number with the reported standard-deviation obtained for the corresponding variable in each group. This column only concerns continuous variables, and should be left blank for categorical variables.
   \item Number of decimal places: An integer that indicates the number of decimal places to which the corresponding mean or proportion was reported (e.g., 1 for "2.5").
   \item Variable type: 1 for continuous variables; 2 for categorical variables.
   \item Name: A character sequence (e.g., with author name and publication year) that names the randomised trial from which data concern.
   }
The example dataframe - example_trials - provides a model regarding the required organisation and content of the dataframe.
For the sake of a faster testing, the example sets the number of simulations at 100. However, we recommend at least 5000 simulations to be performed in order to obtain more accurate results.
}

\section{Source}{

The code for computing p-values for continuous variables is an adaptation of the code provided in AppendixS1 of Carlisle JB and Loadsman JA, 2017, Anaesthesia.
}

\section{References}{

\enumerate{
\item Carlisle JB, Loadsman JA. Evidence for non-random sampling in randomised, controlled trials by Yuhji Saitoh. Anaesthesia 2017;72:17-27
\item Carlisle JB, Dexter F, Pandit JJ, Shafer SL, Yentis SM. Calculating the probability of random sampling for continuous variables in submitted or published randomised controlled trials. Anaesthesia 2015;70:848-858
}
}

\examples{
sim_distr(100,example_trials, TRUE)

}
