% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.prop2}
\alias{simstudy.prop2}
\title{simstudy.prop2}
\usage{
simstudy.prop2(
  nx,
  ny,
  px,
  py,
  num.experiments,
  p = NULL,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  correct = TRUE,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  group.name = "group",
  x.value = "x",
  y.value = "y",
  value.name = "value",
  seed = 920173,
  vstr = 3.6
)
}
\arguments{
\item{nx}{A numeric value for the number of observations in the x group for each experiment.}

\item{ny}{A numeric value for the number of observations in the y group for each experiment.}

\item{px}{A numeric value for the probability of success in the x group.}

\item{py}{A numeric value for the probability of success in the y group.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{p}{See help(prop.test).}

\item{alternative}{See help(prop.test).}

\item{conf.level}{See help(prop.test).}

\item{correct}{See help(prop.test).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{group.name}{A character value providing the name of the column of the group labels.}

\item{x.value}{A character value specifying the label used for data in the x group (in the column labled by the group.name parameter).}

\item{y.value}{A character value specifying the label used for data in the y group (in the column labled by the group.name parameter).}

\item{value.name}{A character value specifying the name of the column that contains the value of the simulated data.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing the following components:

\itemize{
  \item{\code{simdat.prop2}}{A data frame of the simulated data for two proportions.}
  \item{\code{test.statistics.prop2}}{A data frame containing the results of the tests for the two proportions.}
  \item{\code{sim.analysis.prop2}}{A data frame containing the analysis of the simulated study for the two proportions.}
}
}
\description{
simstudy.prop2
}
\examples{
study.noeffect.prop2 <- simstudy.prop2(nx = 40,
 ny = 40, px = 0.4, py = 0.4, num.experiments = 2,
 alternative = "two.sided", conf.level = 0.95, seed = 71)

}
