% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{openProject}
\alias{openProject}
\title{Opens a Simplace project}
\usage{
openProject(simplace, solution, project = nullString, parameterList = NULL)
}
\arguments{
\item{simplace}{handle to the SimplaceWrapper object returned by \code{\link{initSimplace}}}

\item{solution}{solution file with absolute path or path relative to workdir}

\item{project}{project file with absolute path or path relative to workdir, can be omitted to run solution only}

\item{parameterList}{a list with the parameter name as key and parametervalue as value}
}
\value{
invisibly a list with java FWSimsession object as well as the solution, project and parameterList
}
\description{
Initializes a project. Solution is mandatory, project is optional.
Solution and project files can be specified by giving absolute paths or paths relative to
the simplace directory.
Instead of using solution and project files, one can use the content of the solution / project
directly as a string or a "xml_document" class.
}
\seealso{
\code{\link{closeProject}}
}
