% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultaneous.R
\name{simultaneous}
\alias{simultaneous}
\title{Simultaneous Model Constructor}
\usage{
simultaneous(
  seed = NULL,
  verbose = TRUE,
  init = "svd",
  n_max_iter = 10,
  n_loops = 10,
  tol = 1e-05,
  U_i_g = NULL,
  B_j_q = NULL,
  C_k_r = NULL
)
}
\arguments{
\item{seed}{Seed for random sequence generation.}

\item{verbose}{Flag to display output result for each loop.}

\item{init}{The initialization method for the model parameters. Values could be 'svd','random','twcfta' or 'twfcta' Defaults to svd.}

\item{n_max_iter}{Maximum number of iterations to optimize objective function.}

\item{n_loops}{Number of runs/loops in search of the global result.}

\item{tol}{Acceptable tolerance level.}

\item{U_i_g}{Membership function matrix for the objects.}

\item{B_j_q}{Component matrix for the variables.}

\item{C_k_r}{Component matrix for the occasions.}
}
\value{
An object of class "simultaneous".
}
\description{
Initialize model object required by the simultaneous methods.
}
\details{
{
   Two simultaneous models T3Clus and 3FKMeans are the implemented methods.
   \itemize{
      \item T3Clus finds B_j_q and C_k_r such that the between-clusters
      deviance of the component scores is maximized.
     \item 3FKMeans finds B_j_q and C_k_r such that the within-clusters
     deviance of the component scores is minimized.
   }
}
}
\note{
{
   The model finds the best partition described by the best orthogonal
   linear combinations of the variables and orthogonal linear combinations
   of the occasions.
}
}
\examples{
simultaneous()

}
\references{
\insertRef{tucker1966}{simuclustfactor}
\insertRef{VichiRocciKiers}{simuclustfactor}
}
\seealso{
{
 \code{\link{fit.t3clus}} \code{\link{fit.3fkmeans}}
 \code{\link{fit.ct3clus}} \code{\link{tandem}}
}
}
