% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_statement}
\alias{aws_policy_statement}
\title{Create a policy statement}
\usage{
aws_policy_statement(action, resource, effect = "Allow", ...)
}
\arguments{
\item{action}{(character) an action. required. see Actions below.}

\item{resource}{(character) the object or objects the statement covers;
see link below for more information}

\item{effect}{(character) valid values: "Allow" (default), "Deny". length==1}

\item{...}{Additional named arguments. See link in Details for options,
and examples below}
}
\value{
a named list
}
\description{
Create a policy statement
}
\details{
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html} #nolint
}
\examples{
aws_policy_statement("iam:GetUser", "*")
aws_policy_statement("iam:GetUser", "*", Sid = "MyStatementId")
aws_policy_statement("iam:GetUser", "*",
  Condition = list(
    StringEqualsIgnoreCase = list("aws:username" = "johndoe")
  )
)
aws_policy_statement("iam:GetUser", "*",
  Principal = list(Service = "s3.amazonaws.com")
)
}
