% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06-chi-square.R
\name{check_coverage_homogeneity}
\alias{check_coverage_homogeneity}
\title{Check coverage distribution}
\usage{
check_coverage_homogeneity(cov_df, k = 3, p = 0.05)
}
\arguments{
\item{cov_df}{A \code{\link[=data.frame]{data.frame()}} of stratified coverage survey data to get
overall coverage estimates of. \code{cov_df} should have a variable named
\code{cases_in} for number of SAM or MAM cases in the programme found during the
survey, \code{cases_out} for number SAM or MAM cases not in the programme found
during the survey, and \code{rec_in} for children recovering from SAM or MAM who
are in the programme found during the survey. A final required variable
should be one that contains identifying geographical information
corresponding to the location from which each row of the survey data was
collected from.}

\item{k}{Correction factor. Ratio of the mean length of an untreated episode
to the mean length of a CMAM treatment episode}

\item{p}{Minimum p-value to test statistic. Default is 0.05.}
}
\value{
A named list of 2 lists: one for case-finding effectiveness (\emph{cf})
and the second for treatment coverage (\emph{tc}). For each list, the following
values are provided:
\itemize{
\item \strong{statistic} - calculated chi-square statistic
\item \strong{df} - degrees of freedom
\item \strong{p} - p-value of chi-square statistic
}
}
\description{
Check coverage distribution
}
\examples{
check_coverage_homogeneity(survey_data)

}
