% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep-annotation.R
\name{sleep_annotation}
\alias{sleep_annotation}
\alias{sleep_dam_annotation}
\title{Score sleep behaviour from immobility}
\usage{
sleep_annotation(
  data,
  time_window_length = 10,
  min_time_immobile = 300,
  motion_detector_FUN = max_velocity_detector,
  ...
)

sleep_dam_annotation(data, min_time_immobile = 300)
}
\arguments{
\item{data}{\link[data.table:data.table]{data.table::data.table} containing behavioural variable from or one multiple animals.
When it has a key, unique values, are assumed to represent unique individuals (e.g. in a \link[behavr:behavr]{behavr::behavr} table).
Otherwise, it analysis the data as coming from a single animal. \code{data} must have a column \code{t} representing time.}

\item{time_window_length}{number of seconds to be used by the motion classifier.
This corresponds to the sampling period of the output data.}

\item{min_time_immobile}{Minimal duration (in s) of a sleep bout.
Immobility bouts longer or equal to this value are considered as sleep.}

\item{motion_detector_FUN}{function used to classify movement}

\item{...}{extra arguments to be passed to \code{motion_classifier_FUN}.}
}
\value{
a \link[behavr:behavr]{behavr::behavr} table similar to \code{data} with additional variables/annotations (i.e. \code{moving} and \code{asleep}).
The resulting data will only have one data point every \code{time_window_length} seconds.
}
\description{
This function first uses a motion classifier to decide whether an animal is moving during a given time window.
Then, it defines sleep as contiguous immobility for a minimum duration.
}
\details{
The default \code{time_window_length} is 300 seconds -- it is also known as the "5-minute rule".
\code{sleep_annotation} is typically used for ethoscope data, whilst \code{sleep_dam_annotation} only works on DAM2 data.
These functions are \emph{rarely used directly}, but rather passed as an argument to a data loading function,
so that analysis can be performed on the go.
}
\examples{
dt_one_animal <- toy_ethoscope_data(seed=2)
####### Ethoscope, corrected velocity classification #########
sleep_dt <-  sleep_annotation(dt_one_animal, masking_duration=0)
print(sleep_dt)
# We could make a sleep `barecode'
\dontrun{
library(ggplot2)
ggplot(sleep_dt, aes(t,y="Animal 1",fill=asleep)) +
                                   geom_tile() + scale_x_time()
}
####### Ethoscope, virutal beam cross classification #########
sleep_dt2 <-  sleep_annotation(dt_one_animal,
                             motion_detector_FUN=virtual_beam_cross_detector)
\dontrun{
library(ggplot2)
ggplot(sleep_dt2, aes(t,y="Animal 1",fill=asleep)) +
                                   geom_tile() + scale_x_time()
}
####### DAM data, de facto beam cross classification ######
dt_one_animal <- toy_dam_data(seed=7)
sleep_dt <- sleep_dam_annotation(dt_one_animal)
\dontrun{
library(ggplot2)
ggplot(sleep_dt, aes(t,y="Animal 1",fill=asleep)) +
                                   geom_tile() + scale_x_time()
}
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/sleepr}{rethomic tutorial section} -- on sleep analysis
}
}
\seealso{
\itemize{
\item \link{motion_detectors} -- options for the \code{motion_detector_FUN} argument
\item \link{bout_analysis} -- to further analyse sleep bouts in terms of onset and length
}
}
