% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-method.R
\name{predict.slm}
\alias{predict.slm}
\title{Predict for slm object}
\usage{
\method{predict}{slm}(object, newdata = NULL, interval = "confidence",
  level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{slm}.}

\item{newdata}{an optional data frame in which to look for variables with which to predict.
\code{newdata} must contain only variables and not the intercept.
If omitted, the fitted values are used.}

\item{interval}{type of interval calculation. It can be only \code{interval = "confidence"}, the default value. It computes
the confidence intervals for \eqn{x' beta}, where \eqn{x'} is a new observation of the design.}

\item{level}{a number between 0 and 1, which indicates the tolerance/confidence level.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
This function produces a vector of predictions or a matrix of predictions and bounds with column names \code{fit}, \code{lwr},
 and \code{upr} if \code{interval} is set.
}
\description{
Predicted values based on \code{slm} object.
}
\details{
This function produces predicted values, obtained by evaluating the regression function in the frame \code{newdata}
 (which defaults to \code{model.frame(object)}). If \code{newdata} is omitted the predictions are based on the data used for the fit.
}
\examples{
data("shan")
reg1 = slm(shan$PM_Xuhui ~ . , data = shan, method_cov_st = "fitAR", model_selec = -1)
predict(reg1)

data("co2")
y = as.vector(co2)
x = as.vector(time(co2)) - 1958
reg2 = slm(y ~ x + I(x^2) + I(x^3) + sin(2*pi*x) + cos(2*pi*x) + sin(4*pi*x) +
 cos(4*pi*x) + sin(6*pi*x) + cos(6*pi*x) + sin(8*pi*x) + cos(8*pi*x),
 method_cov_st = "fitAR", model_selec = -1)
predict(reg2)
}
\seealso{
\code{\link[stats:predict.lm]{predict.lm}}.
}
