% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{regimeplot.slouch}
\alias{regimeplot.slouch}
\alias{regimeplot}
\title{Plot the internal regimes for a given fitted model}
\usage{
\method{regimeplot}{slouch}(x, ...)

regimeplot(x, ...)
}
\arguments{
\item{x}{an object of class 'slouch'}

\item{...}{additional parameters passed to plot.phylo(...)}
}
\value{
nothing
}
\description{
Plot the internal regimes for a given fitted model
}
\section{Methods (by class)}{
\itemize{
\item \code{regimeplot(slouch)}: Regimeplot for the 'slouch' object

}}
\examples{

data(artiodactyla)
data(neocortex)

neocortex <- neocortex[match(artiodactyla$tip.label, neocortex$species), ]

m0 <- slouch.fit(phy = artiodactyla,
                 species = neocortex$species,
                 response = neocortex$body_mass_g_log_mean,
                 mv.response = neocortex$body_mass_g_log_varmean,
                 fixed.fact = neocortex$diet,
                 hillclimb = TRUE)
                 
regimeplot(m0)

}
