% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{airtemp}
\alias{airtemp}
\title{Air temperature}
\format{
A data frame with 100 rows and 4 variables:
\describe{
  \item{Unit}{Factor. Unique identifier for each observation.}
  \item{DayNo}{Integer. Day number on which the measurement was taken.}
  \item{Mercury}{Numeric. Temperature (in degrees Celsius) measured using a mercury thermometer.}
  \item{Thermistor}{Numeric. Temperature (in degrees Celsius) measured using a thermistor thermometer.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
airtemp
}
\description{
Air temperature measurements (°C) recorded at approximately 9 a.m. on 100 days during 2006 using two instruments: a standard glass mercury dry-bulb thermometer and a new electronic dry-bulb thermistor probe. For each day, the dataset includes the day number and paired temperature readings from both devices, enabling direct comparison between the established and new measurement methods.
}
\examples{
# a simple linear regression
fit_ab <- lm(Thermistor ~ Mercury, data = airtemp)
# let intercept be 0
fit_b <- lm(Thermistor ~ 0 + Mercury, data = airtemp)
# test if intercept = 0
anova(fit_b, fit_ab)
# test if slope is equal to 1, given intercept = 0
fit_1 <- lm(Thermistor ~ 0 + offset(Mercury), data = airtemp)
anova(fit_1, fit_b)
}
\keyword{datasets}
