% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{transect}
\alias{transect}
\title{Crop transect beetle counts}
\format{
A data frame with 4 variables: \code{DPlant}, \code{Distance}, \code{fDist}, \code{Count}.
\describe{
  \item{DPlant}{Factor. Unique identifier for each sampled plant.}
  \item{Distance}{Integer. Distance (in meters) from the edge of the field along the transect where the plant was sampled.}
  \item{fDist}{Factor. Factor-level code for distance group along the transect.}
  \item{Count}{Integer. Number of beetles counted on the sampled plant.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
transect
}
\description{
A pilot study was carried out to examine the entry pattern of an insect pest (beetles) into a susceptible crop. Researchers hypothesized that beetles infiltrate the crop from the field edge, advancing toward the centre. Following initial detection of beetles in the field, a transect was established running from the field edge toward the centre, with beetle sampling conducted at 2-meter intervals. At each sampling point, beetles were counted on four randomly selected plants to provide replicate measurements for each distance. The resulting data consist of the distance from the crop edge (variate Distance) and the corresponding beetle count (variate Count) for each sampled plant. This structure allows for analysis of spatial trends in beetle infestation across the field transect.
}
\examples{
anova(lm(log10(Count) ~ Distance + fDist, data = transect))

}
\keyword{datasets}
