% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.generate.centroid.it}
\alias{smfishHmrf.generate.centroid.it}
\title{Generate cluster centroids, where input is a file.}
\usage{
smfishHmrf.generate.centroid.it(
  expr_file,
  par_k,
  par_seed = -1,
  nstart,
  name = "test",
  output_dir = "."
)
}
\arguments{
\item{expr_file}{expression matrix file. The expression file should be a space-separated file. The rows are genes. The columns are cells. There is no header row. The first column is a gene index (ranges from 1 to the number of genes). Note the first column is not gene name.}

\item{par_k}{number of clusters}

\item{par_seed}{random generator seed (-1 if no fixing). Change the par_seed to vary the initialization.}

\item{nstart}{number of starts (kmeans). It is recommended to set nstart to at least 100 (preferrably 1000).}

\item{name}{name of this run}

\item{output_dir}{output directory; where to store the kmeans results}
}
\value{
A kmeans object which is a list with centers and cluster fields
}
\description{
This function generates cluster centroids from applying kmeans. It accepts an expression matrix file as input.
}
\details{
Note that after running kmeans step, the function also automatically saves the kmeans results to the \code{output_dir} directory. The results will be found in two files:
\enumerate{
\item \code{{output_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.centroid.txt
\item \code{{output_dir}}/k_\code{{par_k}}/f\code{{name}}.gene.ALL.kmeans.txt
}

where \code{{}} refers to the value of parameters.
}
\examples{
mem_file = system.file("extdata", "ftest.expression.txt", package="smfishHmrf")
kk = smfishHmrf.generate.centroid.it(mem_file, par_k=9, par_seed=100, 
    nstart=100, name="test", output_dir=tempdir())
}
