% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_incubation_day_distribution.R
\name{get_incubation_day_distribution}
\alias{get_incubation_day_distribution}
\title{Vector of day-specific probabilities of disease outbreak}
\usage{
get_incubation_day_distribution(max_days, meanlog = 1.69, sdlog = 0.55)
}
\arguments{
\item{max_days}{Number, the maximum length of the incubation time, defined as number.}

\item{meanlog}{Number, the parameter of mean from the log-normal distribution.}

\item{sdlog}{Number, the parameter of sd from the log-normal distribution.}
}
\value{
Vector of day-specific probabilities of disease outbreak.
}
\description{
Creates a vector containing the probabilities of the disease outbreak
for the days 1 to maxi after the infection.
}
\details{
meanlog and sdlog are the log-normal distribution parameters derived from
the incubation period characteristics described in Xin et al. (2021).
}
\examples{
get_incubation_day_distribution(10)
get_incubation_day_distribution(10, meanlog = 1.69, sdlog = 0.55)

}
\references{
Xin H, Wong JY, Murphy C et al. (2021) "The Incubation Period
Distribution of Coronavirus Disease 2019: A Systematic Review and Meta-Analysis".
\emph{Clinical Infectious Diseases}, 73(12): 2344-2352.
}
