% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBBOBFunction.R
\name{makeBBOBFunction}
\alias{makeBBOBFunction}
\title{Generator for the noiseless function set of the real-parameter Black-Box
Optimization Benchmarking (BBOB).}
\usage{
makeBBOBFunction(dimensions, fid, iid)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Problem dimension. Integer value between 2 and 40.}

\item{fid}{[\code{integer(1)}]\cr
Function identifier. Integer value between 1 and 24.}

\item{iid}{[\code{integer(1)}]\cr
Instance identifier. Integer value greater than or equal 1.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
Generator for the noiseless function set of the real-parameter Black-Box
Optimization Benchmarking (BBOB).
}
\note{
It is possible to pass a matrix of parameters to the functions, where
each column consists of one parameter setting.
}
\examples{
# get the first instance of the 2D Sphere function
fn = makeBBOBFunction(dimensions = 2L, fid = 1L, iid = 1L)
if (require(plot3D)) {
  plot3D(fn, contour = TRUE)
}
}
\references{
See the \href{http://numbbo.github.io/coco/?id=bbob-2009-downloads}{BBOB website}
for a detailed description of the BBOB functions.
}
