% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_auc_all.R
\name{sm_auc_all}
\alias{sm_auc_all}
\title{Calculating Area under Curve across multiple conditions and subjects}
\usage{
sm_auc_all(data, subjects, groups, conditions, x, values)
}
\arguments{
\item{data}{Name of the variable that stores the data frame that contains
the columns with the specified column names.}

\item{subjects}{The name of the column of the data frame that contains subjects.
It must be strings.}

\item{groups}{The name of the column of the data frame that contains each group.
It must be strings.}

\item{conditions}{The name of the column of the data frame that contains each condition.
It must be strings.}

\item{x}{The name of the column of the data frame that contains the
x-axis points/x coordinates from which the AUC can be calculated.
It must be strings. The column must not have
characters.}

\item{values}{The name of the column of the data frame that contains the
actual data, which are the y-axis points from which the
AUC can be calculated. It must be strings.}
}
\value{
Returns a data frame containing area under curve from each subject
and experimental condition and/or group.
}
\description{
This function returns a data frame containing AUCs from a data frame
that contains the original raw data. One of the two arguments 'groups'
and 'conditions' must be filled. The function will throw an error
if both arguments are empty.
}
\examples{
library(smplot2)
set.seed(1) # generate random data
day1 = rnorm(16,0,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Value <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c(1,2), each = length(day1))
Condition <- rep('Control', length(day1)*2)
df <- cbind(Subject, Value, Condition, Day)

sm_auc_all(data = df, subjects = 'Subject',values = 'Value',
conditions = 'Condition',x = 'Day')


}
