% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_diffnet_list_from_exp}
\alias{get_diffnet_list_from_exp}
\title{Get the list of differential matrix from a list of expression data}
\usage{
get_diffnet_list_from_exp(
  exp_list,
  adj.beta = -1,
  trans = FALSE,
  location = NULL
)
}
\arguments{
\item{exp_list}{a list of nk-by-p matrices from the K populations.
Rows are samples/observations, while columns are the features.}

\item{adj.beta}{Power to transform correlation matrices to weighted adjacency matrices
by \eqn{N_{ij} = |r_ij|^adj.beta} where \eqn{r_ij} represents the Pearson's correlation.
When \code{adj.beta=0}, the correlation marix is used.
When \code{adj.beta<0}, the covariance matrix is used.
The default value is \code{adj.beta=-1}.}

\item{trans}{logic variable, whether to only consider the trans-correlation (between genes from two different chromosomes or regions)}

\item{location}{vector, the (chromosome) locations for items}
}
\value{
A list of p-by-p differential matrix \eqn{D^{(k,l)}, k < l}.
}
\description{
Given a list of expression data, \eqn{X_1, ..., X_K}, compute the list of differential matrix
\deqn{D^{(k,l)} = N(X_l) - N(X_k), k < l, }
where N() is the covariance matrix, or the weighted adjacency matrices defined as
\deqn{N_{ij} = |corr(i, j)|^beta}
for some constant beta > 0, 1 <= i, j <= p.
Let N represent the regular correlation matrix when beta=0, and covariance matrix when beta<0.
In total, we will have K*(K-1)/2 pairwise differential networks in the list.

If \code{trans = TRUE}, we let \eqn{N_{ij} = 0} if \eqn{i, j} are from the same region based on \code{location}.
Under gene co-expression context, trans-correlation usually refer to the correlation between
two genes \eqn{i, j} from two chromosomes.
}
