% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{snQTL_test_corrnet}
\alias{snQTL_test_corrnet}
\title{Spectral network quantitative trait loci (snQTL) test}
\usage{
snQTL_test_corrnet(
  exp_list,
  method = c("sum", "sum_square", "max", "tensor"),
  npermute = 100,
  seeds = 1:100,
  stats_seed = NULL,
  rho = 1000,
  sumabs = 0.2,
  niter = 20,
  trace = FALSE,
  adj.beta = -1,
  tensor_iter = 20,
  tensor_tol = 10^(-3),
  trans = FALSE,
  location = NULL
)
}
\arguments{
\item{exp_list}{list, a list of expression data from samples with different genotypes; the dimensions for data matrices are n1-by-p, n2-by-p, and n3-by-p, respectively; see "details"}

\item{method}{character, the choice of test statistics; see "details"}

\item{npermute}{number, the number of permutations to obtain empirical p-values}

\item{seeds}{vector, the random seeds for permutation; length of the vector is equal to the \code{npermute}}

\item{stats_seed}{number, the random seed for test statistics calculation with non-permuted data}

\item{rho}{number, a large positive constant adding to the diagonal elements to ensure positive definiteness in symmetric matrix spectral decomposition}

\item{sumabs}{number, the number specify the sparsity level in the matrix/tensor eigenvector; \code{sumabs} takes value between \eqn{1/sqrt(p)} and 1, where \eqn{p} is the dimension; \code{sumabs}\eqn{*sqrt(p)} is the upperbound of the L1 norm of the leading matrix/tensor eigenvector (see \code{symmPMD()})}

\item{niter}{integer, the number of iterations to use in the PMD algorithm (see \code{symmPMD()})}

\item{trace}{logic variable, whether to trace the progress of PMD algorithm (see \code{symmPMD()})}

\item{adj.beta}{number, the power transformation to the correlation matrices (see \code{getDiffMatrix()}); particularly, when \code{adj.beta=0}, the correlation matrix is used, when \code{adj.beta<0}, the covariance matrix is used.}

\item{tensor_iter}{integer, the maximal number of iteration in SSTD algorithm (see \code{max_iter} in \code{SSTD()})}

\item{tensor_tol}{number, a small positive constant for error difference to indicate the SSTD convergence (see \code{tol} in \code{SSTD()})}

\item{trans}{logic variable, whether to only consider the trans-correlation (between genes from two different chromosomes or regions); see "details"}

\item{location}{vector, the (chromosome) locations for genes if \code{trans = TRUE}}
}
\value{
a list containing the following:

\item{method}{character, recall of the choice of test statistics}

\item{res_original}{list, test result for non-permuted data, including the recall of method choices, test statistics, and decomposition components}

\item{res_permute}{list, test results for each permuted data, including the recall of method choices, test statistics, and decomposition components}

\item{emp_p_value}{number, the empirical p-value from permutation test}
}
\description{
Spectral framework to detect network QTLs affecting the co-expression networks. This is the main function for snQTL test.

Given a list of expression data matrices from samples with different gentoypes, we test whether there are significant difference among three co-expression networks.
Statistically, we consider the hypothesis testing task:

\deqn{H_0: N_A = N_B = N_H,}

where \eqn{A,B,H} refer to different genotypes, \eqn{N} refers to the adjacency matrices corresponding to the co-expression network.

We provide four options for the test statistics, composed by sparse matrix/tensor eigenvalues.
We perform permutation test to obtain the empirical p-values for the hypothesis testing.

NOTE: This function is also applicable for generalized cases to compare multiple (K > 3) biological networks.
Instead of separating the samples by genotypes, people can separate the samples into K groups based on other interested metrics, e.g., locations, treatments.
The generalized hypothesis testing problem becomes
\deqn{H_0: N_1 = ... = N_K,}
where \eqn{N_k} refers to the correlation-based network corresponding to the group k.
For consistency, we stick with the original genotype-based setting in this help document.
See details and examples for the generalization on the Github manual https://github.com/Marchhu36/snQTL.
}
\details{
In \code{exp_list}, the data matrices are usually ordered with marker's genotypes AA, BB, and AB.
The expression data is usually normalized. We use expression data to generate the Pearson's correlation co-expression networks.

Given the list of co-expression networks, we generate pairwise differential networks
\deqn{D_{AB} = N_A - N_B, D_{AH} = N_H - N_A, D_{BH} = N_H - N_B.}
We use pairwise differential networks to generate the snQTL test statistics.

We provide four options of test statistics with different choices of \code{method}:
\enumerate{
\item{sum}, the sum of sparse leading matrix eigenvalues (sLMEs) of all pairwise differential networks:

\deqn{Stat_sum =  \lambda(D_{AB}) + \lambda(D_{AH}) + \lambda(D_{BH}),}

where \eqn{\lambda} refers to the sLME operation with given sparsity level set up by \code{sumabs}.

\item{sum_square}, the sum of squared sLMEs:

\deqn{Stat_sumsquare =  \lambda^2(D_{AB}) + \lambda^2(D_{AH}) + \lambda^2(D_{BH}).}

\item{max}, the maximal of sLMEs:

\deqn{Stat_max = \max(\lambda(D_{AB}), \lambda(D_{AH}), \lambda(D_{BH})).}

\item{tensor}, the sparse leading tensor eigenvalue (sLTE) of the differential tensor:

\deqn{Stat_tensor = \Lambda(\mathcal{D}),}

where \eqn{\Lambda} refers to the sLTE operation with given sparsity level set up by \code{sumabs},
and \eqn{\mathcal{D}} is the differential tensor composed by stacking three pairwise differential networks.
}

Additionally, if \code{trans = TRUE}, we only consider the trans-correlation between the genes from two different chromosomes or regions in co-expression networks.
The entries in correlation matrices \eqn{N_{ij} = 0} if gene i and gene j are from the same chromosome or region.
The gene location information is required if \code{trans = TRUE}.
}
\examples{
### artificial example
n1 = 50
n2 = 60
n3 = 100

p = 200

location = c(rep(1,20), rep(2, 50), rep(3, 100), rep(4, 30))

## expression data from null
set.seed(0416) # random seeds for example data
exp1 = matrix(rnorm(n1*p, mean = 0, sd = 1), nrow = n1)
exp2 = matrix(rnorm(n2*p, mean = 0, sd = 1), nrow = n2)
exp3 = matrix(rnorm(n3*p, mean = 0, sd = 1), nrow = n3)

exp_list = list(exp1, exp2, exp3)

result = snQTL_test_corrnet(exp_list = exp_list, method = 'tensor',
                          npermute = 30, seeds = 1:30, stats_seed = 0416,
                          trans = TRUE, location = location)

result$emp_p_value
}
\references{
Hu, J., Weber, J. N., Fuess, L. E., Steinel, N. C., Bolnick, D. I., & Wang, M. (2025). A spectral framework to map QTLs affecting joint differential networks of gene co-expression. PLOS Computational Biology, 21(4), e1012953.
}
