% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sLME}
\alias{sLME}
\title{Calculate of sLME for matrices}
\usage{
sLME(Dmat, rho = 1000, sumabs.seq = 0.2, niter = 20, trace = FALSE)
}
\arguments{
\item{Dmat}{p-by-p numeric matrix, the differential matrix}

\item{rho}{a large positive constant such that \eqn{D+diag(rep(rho, p))} and \eqn{-D+diag(rep(rho, p))}
are positive definite.}

\item{sumabs.seq}{a numeric vector specifing the sequence of sparsity parameters, each between \eqn{1/sqrt(p)} and 1.
Each sumabs*\eqn{\sqrt{p}} is the upperbound of the L_1 norm of leading sparse eigenvector \eqn{v}.}

\item{niter}{the number of iterations to use in the PMD algorithm (see \code{symmPMD()})}

\item{trace}{whether to trace the progress of PMD algorithm (see \code{symmPMD()})}
}
\value{
A list containing the following components:
\item{sumabs.seq}{the sequence of sparsity parameters}
\item{rho}{a positive constant to augment the diagonal of the differential matrix
such that \eqn{D + rho*I} becomes positive definite.}
\item{stats}{a numeric vector of test statistics when using different sparsity parameters
(corresponding to \code{sumabs.seq}).}
\item{sign}{a vector of signs when using different sparsity parameters (corresponding to \code{sumabs.seq}).
Sign is "pos" if the test statistic is given by sEig(D), and "neg" if is given by sEig(-D),
where \code{sEig} denotes the sparse leading eigenvalue.}
\item{v}{the sequence of sparse leading eigenvectors, each row corresponds to one sparsity
parameter given by \code{sumabs.seq}.}
\item{leverage}{the leverage score for genes (defined as \eqn{v^2} element-wise) using
different sparsity parameters. Each row corresponds to one sparsity
parameter given by \code{sumabs.seq}.}
}
\description{
Calculate the sLME given a matrix \eqn{D}.
For any symmetric matrix \eqn{D}, sLME test statistic is defined as
\deqn{max{ sEig(D), sEig(-D) }}
where \code{sEig()} is the sparse leading eigenvalue, defined as
\deqn{max_{v} v^T A v}{max_{v} t(v) *A* v}
subject to
\eqn{||v||_2 \leq 1, ||v||_1 \leq s}{||v||_2 <= 1, ||v||_1 <= s}.
}
\references{
Zhu, Lingxue, et al. "Testing high-dimensional covariance matrices, with application to detecting schizophrenia risk genes." The annals of applied statistics 11.3 (2017): 1810.
}
