% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{single_exp_to_snQTL_stats}
\alias{single_exp_to_snQTL_stats}
\title{Generate one single snQTL test statistics from expression data}
\usage{
single_exp_to_snQTL_stats(
  seed = NULL,
  permute = FALSE,
  exp_list,
  method = c("sum", "sum_square", "max", "tensor"),
  rho = 1000,
  sumabs = 0.2,
  niter = 20,
  trace = FALSE,
  adj.beta = -1,
  tensor_iter = 20,
  tensor_tol = 10^(-3),
  trans = FALSE,
  location = NULL
)
}
\arguments{
\item{seed}{number, the random seed to shuffle the expression data if \code{permute = TRUE} and for \code{SSTD()} initialization if \code{method = "tensor"}}

\item{permute}{logic variable, whether to shuffle the samples in expression data; see "details"}

\item{exp_list}{list, a list of expression data from samples with different genotypes; see "details"}

\item{method}{character, the choice of test statistics (see \code{net_to_stats()})}

\item{rho}{number, a large positive constant adding to the diagonal elements to ensure positive definiteness in symmetric matrix spectral decomposition}

\item{sumabs}{number, the number specify the sparsity level in the matrix/tensor eigenvector; \code{sumabs} takes value between \eqn{1/sqrt(p)} and 1, where \eqn{p} is the dimension; \code{sumabs}\eqn{*sqrt(p)} is the upperbound of the L1 norm of the leading matrix/tensor eigenvector (see \code{symmPMD()})}

\item{niter}{integer, the number of iterations to use in the PMD algorithm (see \code{symmPMD()})}

\item{trace}{logic variable, whether to trace the progress of PMD algorithm (see \code{symmPMD()})}

\item{adj.beta}{number, the power transformation to the correlation matrices (see \code{getDiffMatrix()}); particularly, when \code{adj.beta=0}, the correlation matrix is used, when \code{adj.beta<0}, the covariance matrix is used.}

\item{tensor_iter}{integer, the maximal number of iteration in SSTD algorithm (see \code{max_iter} in \code{SSTD()})}

\item{tensor_tol}{number, a small positive constant for error difference to indicate the SSTD convergence (see \code{tol} in \code{SSTD()})}

\item{trans}{logic variable, whether to only consider the trans-correlation (between genes from two different chromosomes or regions); see "details"}

\item{location}{vector, the (chromosome) locations for genes if \code{trans = TRUE}}
}
\value{
a list containing the following:

\item{method}{character, recall of the choice of test statistics}

\item{permute}{logic variable, recall of the choice of permutation}

\item{stats}{number, the calculated test statistics with given expression list and choices}

\item{decomp_result}{list, if \code{method = c("sum", "sum_square", "max")}, the matrix decomposition components for all pairwise differential networks are recorded; if \code{method = "tensor"}, the tensor decomposition components for the differential tensor are recorded}
}
\description{
Generate one single snQTL test statistics from a given list of expression data.
This function takes a list of expression data, the choice of test statistics, the choice to permute or not,
the choice of considering trans-correlation or not, and other computational tuning parameters as inputs.
Outputs include the calculated statistics, recall of the choices, and the decomposition components associated with the statistics.
}
\details{
In \code{exp_list}, the dimensions for data matrices are n1-by-p, n2-by-p, and n3-by-p, respectively.
The expression data is usually normalized. We use expression data to generate the Pearson's correlation co-expression networks.

If \code{permute = TRUE}, we shuffle the samples in three expression matrices while keeping the same dimensions.
The test statistics from randomly shuffled data are considered as the statistics from null distribution.

If \code{trans = TRUE}, we only consider the trans-correlation between the genes from two different chromosomes or regions in co-expression networks.
The entries in correlation matrices \eqn{N_{ij} = 0} if gene i and gene j are from the same chromosome or region.
}
\references{
Hu, J., Weber, J. N., Fuess, L. E., Steinel, N. C., Bolnick, D. I., & Wang, M. (2025). A spectral framework to map QTLs affecting joint differential networks of gene co-expression. PLOS Computational Biology, 21(4), e1012953.
}
