% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snc.r
\name{snc}
\alias{snc}
\title{Strongest Neighbor Coherence (SNC)}
\usage{
snc(R, k = 2, factors = NULL, digits = 3)
}
\arguments{
\item{R}{A square item correlation matrix (symmetric, 1s on the diagonal).}

\item{k}{Integer. Number of strongest neighbors to use for each item (default = 2).}

\item{factors}{Optional. A vector of factor assignments for items, used to compute group-level means.}

\item{digits}{Number of decimal places to round to (default = 3).}
}
\value{
An object of class \code{"snc"} with:
\describe{
  \item{overall}{Mean SNC value across all items}
  \item{items}{A data frame of item-level SNC values}
  \item{factors}{(Optional) A data frame of factor-level mean SNC values}
}
}
\description{
Computes Strongest Neighbor Coherence (SNC), a rotation-free structural diagnostic
that evaluates how well each item aligns with its top-k most strongly correlated neighbors.
}
\examples{
R <- matrix(c(1, .6, .3, .6, 1, .5, .3, .5, 1), 3, 3)
rownames(R) <- colnames(R) <- c("Item1", "Item2", "Item3")
snc(R)

}
