% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snprelate_qc.R
\name{snprelate_qc}
\alias{snprelate_qc}
\title{snprelate_qc}
\usage{
snprelate_qc(
  gdata,
  samples_nas = 0.03,
  ibs = 0.99,
  keep_ids = NULL,
  snps_nas = 0.01,
  maf = 0.05,
  tagsnp = 0.8,
  n_cores = 1
)
}
\arguments{
\item{gdata}{Genotype data object}

\item{samples_nas}{NA threshold for samples, default 3 pct}

\item{ibs}{Samples identity by state threshold, default 99 pct}

\item{keep_ids}{Samples ids to keep even if IBS is higher than threshold.
Used for monozygotic twins.}

\item{snps_nas}{NA threshold for SNPs, default 1 pct}

\item{maf}{Minor allele frequency threshold, default 5 pct}

\item{tagsnp}{TagSNP r2 correlation threshold, default 0.8}

\item{n_cores}{Number of cores}
}
\value{
List of gdata, Genotype data object, and df_qc, QC info data frame
}
\description{
Quality control using SNPRelate functions.
}
\examples{
library(snplinkage)
gds_path <- save_hgdp_as_gds()
gdata <- load_gds_as_genotype_data(gds_path)
qc <- snprelate_qc(gdata, tagsnp = .99)

}
