% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_triads.r
\name{get.category.relations}
\alias{get.category.relations}
\title{Get and calculate the relationships and oppositions between each pair of categories}
\usage{
get.category.relations(
  r,
  ind = r$indicator.matrix.active,
  dim = c(1, 2),
  rel = t(combn(colnames(ind), 2))
)
}
\arguments{
\item{r}{an soc.mca result object}

\item{ind}{an indicator matrix, see \link{indicator}}

\item{dim}{a numeric vector with the dimensions for the coordinates. This is only sent to \link{extract_mod}.}

\item{rel}{a matrix with pairs of categories}
}
\value{
a tibble
}
\description{
Use this function to calculate PEM \link[descriptio]{pem.table} values, chisq, distance and coordinates for each pair of categories in either an indicator matrix or the categories from an soc.mca result object. These relationship are useful for both diagnostics, analysis, interpretation and plotting. 
For plotting combine with \link{add.category.relations} to build your plot.
}
\examples{
example(soc.mca)
get.category.relations(result)
}
