# nocov start

.onLoad <- function(...) {
  as_character_vector <- function(x) {
    # works for both x = NULL and x = list()
    if (length(x) == 0) {
      return(character(0))
    }
    unlist(x)
  }

  # Register input handlers
  shiny::registerInputHandler(
    force = TRUE,
    "sortablejs.rank_list",
    function(val, shinysession, name) {
      ret <- as_character_vector(val)
      ret
    }
  )

  shiny::registerInputHandler(
    force = TRUE,
    "sortablejs.bucket_list",
    function(val, shinysession, name) {
      ret <- lapply(val, function(x) {
        as_character_vector(x)
      })
      ret
    }
  )
}

.onAttach <- function(libname, pkgname) {
  if (!isTRUE(getOption("sortable.modules_message_shown"))) {
    msg <- cli::format_inline(
      "To use sortable with shiny modules, run {.run sortable::enable_modules()} to opt into the new standard. ",
      "See https://rstudio.github.io/sortable/articles/shiny_modules.html for more information."
    )

    packageStartupMessage(msg)
    options(sortable.modules_message_shown = TRUE)
  }
}

# nocov end
