% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screening_classes.R
\name{constructor_screencoef}
\alias{constructor_screencoef}
\title{Constructor Function for Building \code{'screencoef'} Objects}
\usage{
constructor_screencoef(name, generate_fun)
}
\arguments{
\item{name}{character}

\item{generate_fun}{function for generating the screening coefficient. This
function should have arguments  and   \code{y} (vector of responses -- standardized
for Gaussian family), \code{x} (the matrix of standardized predictors) and a
\code{'screencoef'} object.}
}
\value{
a function which in turn creates an object of class \code{'screencoef'}
}
\description{
The created function will return a object of class \code{'screencoef'} which
constitutes of a list. The attributes of the generating object will include by
default \code{type}, which can take one of two values \code{"prob"} (indicating
probabilistic screening should be employed),
\code{"fixed"} (indicating that the top \code{nscreen} variables should be employed).
}
\details{
Creates an object class \code{'screencoef'} using arguments passed by user.
}
\examples{
generate_scr_sirs <- function(y, x, object) {
  res_screen <- do.call(function(...)
    VariableScreening::screenIID(x, y, ...),
    object$control)
  coefs <- res_screen$measurement
  coefs
}
screen_sirs <- constructor_screencoef("screen_sirs",
  generate_fun = generate_scr_sirs)
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_example <- spar(example_data$x, example_data$y,
  screencoef = screen_sirs(control = list(method = "SIRS")),
  rp = rp_sparse())
spar_example
}
