% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_classification_one_vs_rest.R
\name{ml_one_vs_rest}
\alias{ml_one_vs_rest}
\title{Spark ML -- OneVsRest}
\usage{
ml_one_vs_rest(
  x,
  formula = NULL,
  classifier = NULL,
  features_col = "features",
  label_col = "label",
  prediction_col = "prediction",
  uid = random_string("one_vs_rest_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{formula}{Used when \code{x} is a \code{tbl_spark}. R formula as a character string or a formula. This is used to transform the input dataframe before fitting, see \link{ft_r_formula} for details.}

\item{classifier}{Object of class \code{ml_estimator}. Base binary classifier that we reduce multiclass classification into.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; see Details.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} object. If
it is a \code{ml_pipeline}, it will return a pipeline with the predictor
appended to it. If a \code{tbl_spark}, it will return a \code{tbl_spark} with
the predictions added to it.
}
\description{
Reduction of Multiclass Classification to Binary Classification. Performs reduction using one against all strategy. For a multiclass classification with k classes, train k models (one per class). Each example is scored against all k models and the model with highest score is picked to label the example.
}
\seealso{
Other ml algorithms: 
\code{\link{ml_aft_survival_regression}()},
\code{\link{ml_decision_tree_classifier}()},
\code{\link{ml_gbt_classifier}()},
\code{\link{ml_generalized_linear_regression}()},
\code{\link{ml_isotonic_regression}()},
\code{\link{ml_linear_regression}()},
\code{\link{ml_linear_svc}()},
\code{\link{ml_logistic_regression}()},
\code{\link{ml_multilayer_perceptron_classifier}()},
\code{\link{ml_naive_bayes}()},
\code{\link{ml_random_forest_classifier}()}
}
\concept{ml algorithms}
