% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{sparseLRMatrix}
\alias{sparseLRMatrix}
\title{Create a sparse plus low rank matrix}
\usage{
sparseLRMatrix(sparse, U, V)
}
\arguments{
\item{sparse}{sparseMatrix.}

\item{U}{Matrix.}

\item{V}{Matrix.}
}
\value{
A \linkS4class{sparseLRMatrix} S4 object.
}
\description{
Create a sparse plus low rank matrix
}
\examples{

set.seed(528491)

n <- 50
m <- 40
k <- 3

A <- rsparsematrix(n, m, 0.1)

U <- Matrix(rnorm(n * k), nrow = n, ncol = k)
V <- Matrix(rnorm(m * k), nrow = m, ncol = k)

# construct the matrix, which represents A + U \%*\% t(V)
X <- sparseLRMatrix(sparse = A, U = U, V = V)

dim(X)

s <- svds(X, 5)  # efficient

}
